/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import resources.ResourceManager;
import resources.icons.FileBasedIcon;

public abstract class LazyImageIcon
extends ImageIcon
implements FileBasedIcon {
    private boolean loaded;

    protected LazyImageIcon(String name) {
        this.setDescription(name);
    }

    private synchronized void init() {
        if (!this.loaded || this.sourceIconChanged()) {
            this.loaded = true;
            ImageIcon imageIcon = this.createImageIcon();
            if (imageIcon == null) {
                imageIcon = this.getDefaultIcon();
            }
            super.setImage(imageIcon.getImage());
            super.setDescription(this.getDescription());
        }
    }

    protected abstract ImageIcon createImageIcon();

    protected boolean sourceIconChanged() {
        return false;
    }

    @Override
    public String getFilename() {
        return this.getDescription();
    }

    @Override
    public Image getImage() {
        this.init();
        return super.getImage();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        this.init();
        return super.getAccessibleContext();
    }

    @Override
    public String getDescription() {
        this.init();
        return super.getDescription();
    }

    @Override
    public int getIconHeight() {
        this.init();
        return super.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.init();
        return super.getIconWidth();
    }

    @Override
    public int getImageLoadStatus() {
        this.init();
        return super.getImageLoadStatus();
    }

    @Override
    public ImageObserver getImageObserver() {
        this.init();
        return super.getImageObserver();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.init();
        super.paintIcon(c, g, x, y);
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    @Override
    public void setImage(Image image) {
        this.init();
        super.setImage(image);
    }

    @Override
    public String toString() {
        this.init();
        return super.toString();
    }

    private ImageIcon getDefaultIcon() {
        ImageIcon defaultIcon = ResourceManager.getDefaultIcon();
        if (this == defaultIcon) {
            throw new IllegalStateException("Unexpected failure loading the default icon!");
        }
        return defaultIcon;
    }
}

