/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.isf;

import ghidra.dbg.isf.IsfClientHandler;
import ghidra.dbg.isf.protocol.Isf;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class IsfConnectionHandler
extends Thread {
    private Socket socket;
    private IsfClientHandler handler;

    public IsfConnectionHandler(Socket socket, IsfClientHandler handler) {
        this.socket = socket;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            Msg.info((Object)this, (Object)"Handler started...");
            InputStream inputStream = this.socket.getInputStream();
            while (!this.socket.isClosed()) {
                Isf.RootMessage root = Isf.RootMessage.parseDelimitedFrom(inputStream);
                if (root == null) continue;
                Isf.RootMessage msg = this.handler.processMessage(root);
                OutputStream out = this.socket.getOutputStream();
                msg.writeDelimitedTo(out);
                out.flush();
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e);
        }
    }
}

