/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.correlate.DisambiguateByBytes;
import ghidra.program.model.correlate.DisambiguateByChild;
import ghidra.program.model.correlate.DisambiguateByParent;
import ghidra.program.model.correlate.DisambiguateByParentWithOrder;
import ghidra.program.model.correlate.DisambiguateStrategy;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashCalculator;
import ghidra.program.model.correlate.HashEntry;
import ghidra.program.model.correlate.HashStore;
import ghidra.program.model.correlate.InstructHash;
import ghidra.program.model.correlate.MnemonicHashCalculator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HashedFunctionAddressCorrelation
implements ListingAddressCorrelation {
    private Duo<Function> functions;
    private TreeMap<Address, Address> srcToDest;
    private TreeMap<Address, Address> destToSrc;
    private HashStore srcStore;
    private HashStore destStore;
    private HashCalculator hashCalc;
    private TaskMonitor monitor;

    public HashedFunctionAddressCorrelation(Function leftFunction, Function rightFunction, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (leftFunction == null || rightFunction == null) {
            throw new IllegalArgumentException("Functions can't be null!");
        }
        this.functions = new Duo((Object)leftFunction, (Object)rightFunction);
        this.monitor = monitor;
        this.srcToDest = new TreeMap();
        this.destToSrc = new TreeMap();
        this.srcStore = new HashStore(leftFunction, monitor);
        this.destStore = new HashStore(rightFunction, monitor);
        this.hashCalc = new MnemonicHashCalculator();
        this.calculate();
        this.buildFinalMaps();
    }

    @Override
    public Program getProgram(Duo.Side side) {
        return ((Function)this.functions.get(side)).getProgram();
    }

    @Override
    public AddressSetView getAddresses(Duo.Side side) {
        return ((Function)this.functions.get(side)).getBody();
    }

    public int getTotalInstructionsInFirst() {
        return this.srcStore.getTotalInstructions();
    }

    public int getTotalInstructionsInSecond() {
        return this.destStore.getTotalInstructions();
    }

    public int numMatchedInstructionsInFirst() {
        return this.srcStore.numMatchedInstructions();
    }

    public int numMatchedInstructionsInSecond() {
        return this.destStore.numMatchedInstructions();
    }

    public List<Instruction> getUnmatchedInstructionsInFirst() {
        return this.srcStore.getUnmatchedInstructions();
    }

    public List<Instruction> getUnmatchedInstructionsInSecond() {
        return this.destStore.getUnmatchedInstructions();
    }

    private void declareMatch(HashEntry srcEntry, InstructHash srcInstruct, HashEntry destEntry, InstructHash destInstruct) throws MemoryAccessException {
        boolean cancelMatch = false;
        int matchSize = srcEntry.hash.size;
        if (!srcInstruct.allUnknown(matchSize)) {
            this.srcStore.removeHash(srcEntry);
            cancelMatch = true;
        }
        if (!destInstruct.allUnknown(matchSize)) {
            this.destStore.removeHash(destEntry);
            cancelMatch = true;
        }
        if (cancelMatch) {
            return;
        }
        ArrayList<Instruction> srcInstructVec = new ArrayList<Instruction>();
        ArrayList<Instruction> destInstructVec = new ArrayList<Instruction>();
        ArrayList<CodeBlock> srcBlockVec = new ArrayList<CodeBlock>();
        ArrayList<CodeBlock> destBlockVec = new ArrayList<CodeBlock>();
        HashStore.NgramMatch srcMatch = new HashStore.NgramMatch();
        HashStore.NgramMatch destMatch = new HashStore.NgramMatch();
        HashStore.extendMatch(matchSize, srcInstruct, srcMatch, destInstruct, destMatch, this.hashCalc);
        this.srcStore.matchHash(srcMatch, srcInstructVec, srcBlockVec);
        this.destStore.matchHash(destMatch, destInstructVec, destBlockVec);
        for (int i = 0; i < srcInstructVec.size(); ++i) {
            this.srcToDest.put(srcInstructVec.get(i).getAddress(), destInstructVec.get(i).getAddress());
        }
    }

    private static TreeMap<Hash, DisambiguatorEntry> constructDisambiguatorTree(HashEntry entry, HashStore store, DisambiguateStrategy strategy) throws CancelledException, MemoryAccessException {
        TreeMap<Hash, DisambiguatorEntry> entryMap = new TreeMap<Hash, DisambiguatorEntry>();
        int matchSize = entry.hash.size;
        for (InstructHash curInstruct : entry.instList) {
            ArrayList<Hash> hashList = strategy.calcHashes(curInstruct, matchSize, store);
            for (Hash curHash : hashList) {
                DisambiguatorEntry curEntry = entryMap.get(curHash);
                if (curEntry == null) {
                    curEntry = new DisambiguatorEntry(curHash, curInstruct);
                    entryMap.put(curHash, curEntry);
                    continue;
                }
                ++curEntry.count;
            }
        }
        return entryMap;
    }

    private int disambiguateNgramsWithStrategy(DisambiguateStrategy strategy, HashEntry srcEntry, HashEntry destEntry) throws CancelledException, MemoryAccessException {
        TreeMap<Hash, DisambiguatorEntry> srcDisambig = HashedFunctionAddressCorrelation.constructDisambiguatorTree(srcEntry, this.srcStore, strategy);
        TreeMap<Hash, DisambiguatorEntry> destDisambig = HashedFunctionAddressCorrelation.constructDisambiguatorTree(destEntry, this.destStore, strategy);
        int count = 0;
        for (DisambiguatorEntry srcDisEntry : srcDisambig.values()) {
            DisambiguatorEntry destDisEntry;
            if (srcDisEntry.count != 1 || srcDisEntry.instruct.isMatched || (destDisEntry = destDisambig.get(srcDisEntry.hash)) == null || destDisEntry.count != 1 || destDisEntry.instruct.isMatched) continue;
            this.declareMatch(srcEntry, srcDisEntry.instruct, destEntry, destDisEntry.instruct);
            ++count;
        }
        return count;
    }

    private boolean disambiguateMatchingNgrams(HashEntry srcEntry, HashEntry destEntry) throws CancelledException, MemoryAccessException {
        if (srcEntry.hasDuplicateBlocks()) {
            return false;
        }
        if (destEntry.hasDuplicateBlocks()) {
            return false;
        }
        if (srcEntry.hash.size != destEntry.hash.size) {
            return false;
        }
        int count = this.disambiguateNgramsWithStrategy(new DisambiguateByParent(), srcEntry, destEntry);
        if (count != 0) {
            return true;
        }
        count = this.disambiguateNgramsWithStrategy(new DisambiguateByChild(), srcEntry, destEntry);
        if (count != 0) {
            return true;
        }
        count = this.disambiguateNgramsWithStrategy(new DisambiguateByBytes(), srcEntry, destEntry);
        if (count != 0) {
            return true;
        }
        count = this.disambiguateNgramsWithStrategy(new DisambiguateByParentWithOrder(), srcEntry, destEntry);
        return count != 0;
    }

    private void findMatches() throws MemoryAccessException, CancelledException {
        while (!this.srcStore.isEmpty() && !this.destStore.isEmpty()) {
            HashEntry srcEntry = this.srcStore.getFirstEntry();
            HashEntry destEntry = this.destStore.getEntry(srcEntry.hash);
            if (destEntry == null) {
                this.srcStore.removeHash(srcEntry);
                continue;
            }
            if (srcEntry.instList.size() == 1 && destEntry.instList.size() == 1) {
                this.declareMatch(srcEntry, srcEntry.instList.getFirst(), destEntry, destEntry.instList.getFirst());
                continue;
            }
            HashEntry destEntry2 = this.destStore.getFirstEntry();
            HashEntry srcEntry2 = this.srcStore.getEntry(destEntry2.hash);
            if (srcEntry2 == null) {
                this.destStore.removeHash(destEntry2);
                continue;
            }
            if (srcEntry2.instList.size() == 1 && destEntry2.instList.size() == 1) {
                this.declareMatch(srcEntry2, srcEntry2.instList.getFirst(), destEntry2, destEntry2.instList.getFirst());
                continue;
            }
            if (this.disambiguateMatchingNgrams(srcEntry, destEntry)) continue;
            this.srcStore.removeHash(srcEntry);
        }
    }

    private void runPasses(int minLength, int maxLength, boolean wholeBlock, boolean matchBlock, int maxPasses) throws MemoryAccessException, CancelledException {
        int curMatch;
        this.srcStore.calcHashes(minLength, maxLength, wholeBlock, matchBlock, this.hashCalc);
        this.destStore.calcHashes(minLength, maxLength, wholeBlock, matchBlock, this.hashCalc);
        for (int pass = 0; pass < maxPasses && (curMatch = this.srcStore.numMatchedInstructions()) != this.srcStore.getTotalInstructions(); ++pass) {
            this.srcStore.clearSort();
            this.destStore.clearSort();
            this.srcStore.insertHashes();
            this.destStore.insertHashes();
            this.findMatches();
            if (curMatch == this.srcStore.numMatchedInstructions()) break;
        }
    }

    private void calculate() throws MemoryAccessException, CancelledException {
        this.srcStore.calcHashes(5, 10, false, false, this.hashCalc);
        this.srcStore.insertHashes();
        this.destStore.calcHashes(5, 10, false, false, this.hashCalc);
        this.destStore.insertHashes();
        this.findMatches();
        if (this.srcStore.numMatchedInstructions() == this.srcStore.getTotalInstructions()) {
            return;
        }
        if (this.destStore.numMatchedInstructions() == this.destStore.getTotalInstructions()) {
            return;
        }
        this.runPasses(3, 4, true, true, 10);
        if (this.srcStore.numMatchedInstructions() == this.srcStore.getTotalInstructions()) {
            return;
        }
        if (this.destStore.numMatchedInstructions() == this.destStore.getTotalInstructions()) {
            return;
        }
        int curMatch = this.srcStore.numMatchedInstructions();
        this.runPasses(5, 10, false, false, 3);
        if (this.srcStore.numMatchedInstructions() == curMatch) {
            return;
        }
        if (this.srcStore.numMatchedInstructions() == this.srcStore.getTotalInstructions()) {
            return;
        }
        if (this.destStore.numMatchedInstructions() == this.destStore.getTotalInstructions()) {
            return;
        }
        this.runPasses(3, 4, true, true, 10);
    }

    private void buildFinalMaps() {
        for (Map.Entry<Address, Address> entry : this.srcToDest.entrySet()) {
            this.destToSrc.put(entry.getValue(), entry.getKey());
        }
    }

    public Iterator<Map.Entry<Address, Address>> getFirstToSecondIterator() {
        return this.srcToDest.entrySet().iterator();
    }

    @Override
    public Address getAddress(Duo.Side side, Address otherSideAddress) {
        if (side == Duo.Side.LEFT) {
            return this.destToSrc.get(otherSideAddress);
        }
        return this.srcToDest.get(otherSideAddress);
    }

    @Override
    public Function getFunction(Duo.Side side) {
        return (Function)this.functions.get(side);
    }

    private static class DisambiguatorEntry {
        public Hash hash;
        public int count;
        public InstructHash instruct;

        public DisambiguatorEntry(Hash h, InstructHash inst) {
            this.hash = h;
            this.instruct = inst;
            this.count = 1;
        }
    }
}

