/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.BooleanField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class AddressMapDBAdapterV1
extends AddressMapDBAdapter {
    final Schema SCHEMA = new Schema(1, "Key", new Field[]{StringField.INSTANCE, IntField.INSTANCE, BooleanField.INSTANCE}, new String[]{"Space Name", "Segment", "Deleted"});
    final int SPACE_NAME_COL = 0;
    final int SEGMENT_COL = 1;
    final int DELETED_COL = 2;
    private Table table;
    private AddressFactory factory;
    private Address[] addresses;
    private final DBHandle handle;

    AddressMapDBAdapterV1(DBHandle handle, AddressFactory factory, boolean create) throws VersionException, IOException {
        this.handle = handle;
        this.factory = factory;
        if (create) {
            this.table = handle.createTable(TABLE_NAME, this.SCHEMA);
        } else {
            this.table = handle.getTable(TABLE_NAME);
            if (this.table == null || this.table.getSchema().getVersion() < 1) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 1) {
                throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
            }
        }
        this.readAddresses();
    }

    private void readAddresses() throws IOException {
        this.addresses = new Address[this.table.getRecordCount()];
        for (DBRecord rec : this.table) {
            Address addr;
            Object spaceName = rec.getString(0);
            int segment = rec.getIntValue(1);
            boolean deleted = rec.getBooleanValue(2);
            AddressSpace space = this.factory.getAddressSpace((String)spaceName);
            if (deleted || space == null) {
                String deletedName = "Deleted_" + (String)spaceName;
                if (segment != 0) {
                    spaceName = (String)spaceName + "_" + segment;
                }
                GenericAddressSpace sp = new GenericAddressSpace(deletedName, 32, 13, (int)rec.getKey());
                sp.setShowSpaceName(true);
                space = sp;
                segment = 0;
            }
            this.addresses[(int)rec.getKey()] = addr = space.getAddressInThisSpaceOnly((long)segment << 32);
        }
    }

    @Override
    Address[] getBaseAddresses(boolean forceRead) throws IOException {
        if (forceRead || this.table.getRecordCount() != this.addresses.length) {
            this.readAddresses();
        }
        return this.addresses;
    }

    @Override
    List<AddressMapDBAdapter.AddressMapEntry> getEntries() throws IOException {
        ArrayList<AddressMapDBAdapter.AddressMapEntry> list = new ArrayList<AddressMapDBAdapter.AddressMapEntry>();
        for (DBRecord rec : this.table) {
            String spaceName = rec.getString(0);
            list.add(new AddressMapDBAdapter.AddressMapEntry((int)rec.getKey(), spaceName, rec.getIntValue(1), rec.getBooleanValue(2)));
        }
        return list;
    }

    @Override
    void setEntries(List<AddressMapDBAdapter.AddressMapEntry> entries) throws IOException {
        if (this.table.getRecordCount() != 0) {
            throw new IllegalStateException();
        }
        for (AddressMapDBAdapter.AddressMapEntry entry : entries) {
            if (entry.index != this.table.getRecordCount()) {
                throw new IllegalArgumentException("Bad map entry");
            }
            DBRecord rec = this.SCHEMA.createRecord((long)entry.index);
            rec.setString(0, entry.name);
            rec.setIntValue(1, entry.segment);
            rec.setBooleanValue(2, entry.deleted);
            this.table.putRecord(rec);
        }
        this.readAddresses();
    }

    @Override
    Address[] addBaseAddress(Address addr, long normalizedOffset) {
        DBRecord rec = this.SCHEMA.createRecord((long)this.addresses.length);
        AddressSpace space = addr.getAddressSpace();
        rec.setString(0, space.getName());
        int segment = (int)(normalizedOffset >> 32);
        rec.setIntValue(1, segment);
        rec.setBooleanValue(2, false);
        try {
            this.table.putRecord(rec);
        }
        catch (IOException e) {
            return this.addresses;
        }
        Address[] newAddrs = new Address[this.addresses.length + 1];
        System.arraycopy(this.addresses, 0, newAddrs, 0, this.addresses.length);
        newAddrs[this.addresses.length] = addr.getAddressSpace().getAddressInThisSpaceOnly(normalizedOffset & 0xFFFFFFFF00000000L);
        this.addresses = newAddrs;
        return this.addresses;
    }

    @Override
    void clearAll() throws IOException {
        this.table.deleteAll();
        this.addresses = new Address[0];
    }

    @Override
    void setAddressFactory(AddressFactory addrFactory) {
        this.factory = addrFactory;
    }

    @Override
    void renameOverlaySpace(String oldName, String newName) throws IOException {
        for (DBRecord rec : this.table) {
            String spaceName = rec.getString(0);
            boolean deleted = rec.getBooleanValue(2);
            if (deleted || !spaceName.equals(oldName)) continue;
            rec.setString(0, newName);
            this.table.putRecord(rec);
        }
    }

    @Override
    void deleteOverlaySpace(String name) throws IOException {
        for (DBRecord rec : this.table) {
            String spaceName = rec.getString(0);
            if (!spaceName.equals(name)) continue;
            rec.setBooleanValue(2, true);
            this.table.putRecord(rec);
        }
    }

    @Override
    void deleteTable() throws IOException {
        this.handle.deleteTable(TABLE_NAME);
    }
}

