/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.plugin.ai.chat.AssistantProfile;
import org.freeplane.plugin.ai.chat.AssistantProfileStore;

public class AssistantProfileSelectionModel {
    public static final String LAST_PROFILE_ID_PROPERTY = "ai_assistant_profile_last_id";
    private final AssistantProfileStore store;
    private final ResourceController resourceController;
    private final List<Consumer<AssistantProfile>> listeners = new ArrayList<Consumer<AssistantProfile>>();
    private final List<AssistantProfile> profiles = new ArrayList<AssistantProfile>();
    private AssistantProfile selectedProfile;

    public AssistantProfileSelectionModel() {
        this(new AssistantProfileStore(), ResourceController.getResourceController());
    }

    AssistantProfileSelectionModel(AssistantProfileStore store, ResourceController resourceController) {
        this.store = Objects.requireNonNull(store, "store");
        this.resourceController = Objects.requireNonNull(resourceController, "resourceController");
        this.reloadProfiles();
        this.selectById(resourceController.getProperty(LAST_PROFILE_ID_PROPERTY));
    }

    public void reloadProfiles() {
        this.profiles.clear();
        this.profiles.addAll(this.store.loadProfiles());
        this.ensureDefaultProfile();
    }

    public List<AssistantProfile> getProfiles() {
        return new ArrayList<AssistantProfile>(this.profiles);
    }

    public AssistantProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void addSelectionListener(Consumer<AssistantProfile> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void selectById(String id) {
        AssistantProfile profile = this.findById(id).orElse(AssistantProfile.defaultProfile());
        this.setSelectedProfile(profile, true);
    }

    public AssistantProfile findProfileById(String id) {
        return this.findById(id).orElse(null);
    }

    public void setSelectedProfile(AssistantProfile profile, boolean updateLastUsed) {
        String selectedProfileId;
        AssistantProfile assistantProfile = this.selectedProfile = profile == null ? AssistantProfile.defaultProfile() : profile;
        if (updateLastUsed && (selectedProfileId = this.selectedProfile.getId()) != null && !selectedProfileId.trim().isEmpty()) {
            this.resourceController.setProperty(LAST_PROFILE_ID_PROPERTY, selectedProfileId);
        }
        this.notifyListeners();
    }

    public void saveProfiles(List<AssistantProfile> profilesToSave) {
        this.store.saveProfiles(profilesToSave);
        this.reloadProfiles();
    }

    private void ensureDefaultProfile() {
        AssistantProfile defaultProfile = this.profiles.stream().filter(AssistantProfile::isDefault).findFirst().orElse(null);
        if (defaultProfile == null) {
            this.profiles.add(0, AssistantProfile.defaultProfile());
            return;
        }
        this.profiles.remove(defaultProfile);
        this.profiles.add(0, defaultProfile);
    }

    private Optional<AssistantProfile> findById(String id) {
        if (id == null || id.trim().isEmpty()) {
            return Optional.empty();
        }
        return this.profiles.stream().filter(profile -> id.equals(profile.getId())).findFirst();
    }

    private void notifyListeners() {
        for (Consumer<AssistantProfile> listener : this.listeners) {
            listener.accept(this.selectedProfile);
        }
    }
}

