/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ConcreteClassDownTraveler
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public ConcreteClassDownTraveler(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x600) != 0) {
            Clazz[] subClasses = programClass.subClasses;
            if (subClasses != null) {
                for (int index = 0; index < subClasses.length; ++index) {
                    subClasses[index].accept(this);
                }
            }
        } else {
            programClass.accept(this.classVisitor);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if ((libraryClass.getAccessFlags() & 0x600) != 0) {
            Clazz[] subClasses = libraryClass.subClasses;
            if (subClasses != null) {
                for (int index = 0; index < subClasses.length; ++index) {
                    subClasses[index].accept(this);
                }
            }
        } else {
            libraryClass.accept(this.classVisitor);
        }
    }
}

