/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;

public class SecurityUtils {
    private static final MethodHandle CALL_AS = SecurityUtils.lookupCallAs();
    private static final MethodHandle CURRENT = SecurityUtils.lookupCurrent();
    private static final MethodHandle DO_PRIVILEGED = SecurityUtils.lookupDoPrivileged();

    private SecurityUtils() {
    }

    private static MethodHandle lookupCallAs() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            try {
                return lookup.findStatic(Subject.class, "callAs", MethodType.methodType(Object.class, Subject.class, Callable.class));
            }
            catch (NoSuchMethodException x) {
                try {
                    MethodType oldSignature = MethodType.methodType(Object.class, Subject.class, PrivilegedExceptionAction.class);
                    MethodHandle doAs = lookup.findStatic(Subject.class, "doAs", oldSignature);
                    MethodType convertSignature = MethodType.methodType(PrivilegedExceptionAction.class, Callable.class);
                    MethodHandle converter = lookup.findStatic(SecurityUtils.class, "callableToPrivilegedExceptionAction", convertSignature);
                    return MethodHandles.filterArguments(doAs, 1, converter);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupDoPrivileged() {
        try {
            Class<?> klass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessController");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(klass, "doPrivileged", MethodType.methodType(Object.class, PrivilegedAction.class));
        }
        catch (IllegalAccessException | NoSuchMethodException x) {
            throw new AssertionError((Object)x);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static MethodHandle lookupCurrent() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findStatic(Subject.class, "current", MethodType.methodType(Subject.class));
        }
        catch (NoSuchMethodException e) {
            MethodHandle getContext = SecurityUtils.lookupGetContext();
            MethodHandle getSubject = SecurityUtils.lookupGetSubject();
            return MethodHandles.filterReturnValue(getContext, getSubject);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetSubject() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> contextklass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            return lookup.findStatic(Subject.class, "getSubject", MethodType.methodType(Subject.class, contextklass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetContext() {
        try {
            Class<?> controllerKlass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessController");
            Class<?> contextklass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(controllerKlass, "getContext", MethodType.methodType(contextklass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (DO_PRIVILEGED == null) {
            return action.run();
        }
        return SecurityUtils.doPrivileged(DO_PRIVILEGED, action);
    }

    private static <T> T doPrivileged(MethodHandle doPrivileged, PrivilegedAction<T> action) {
        try {
            return (T)doPrivileged.invoke(action);
        }
        catch (Throwable t) {
            throw SecurityUtils.sneakyThrow(t);
        }
    }

    public static <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
        try {
            return (T)CALL_AS.invoke(subject, action);
        }
        catch (PrivilegedActionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (Throwable t) {
            throw SecurityUtils.sneakyThrow(t);
        }
    }

    public static Subject currentSubject() {
        try {
            return CURRENT.invoke();
        }
        catch (Throwable t) {
            throw SecurityUtils.sneakyThrow(t);
        }
    }

    private static <T> PrivilegedExceptionAction<T> callableToPrivilegedExceptionAction(Callable<T> callable) {
        return callable::call;
    }

    private static <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

