/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgentModelSpec;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.telemetry.metrics.tags.Tags;

public class MLAgent
implements ToXContentObject,
Writeable {
    public static final String AGENT_NAME_FIELD = "name";
    public static final String AGENT_TYPE_FIELD = "type";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String LLM_FIELD = "llm";
    public static final String MODEL_FIELD = "model";
    public static final String TOOLS_FIELD = "tools";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String MEMORY_FIELD = "memory";
    public static final String MEMORY_ID_FIELD = "memory_id";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String APP_TYPE_FIELD = "app_type";
    public static final String IS_HIDDEN_FIELD = "is_hidden";
    public static final String CONTEXT_MANAGEMENT_NAME_FIELD = "context_management_name";
    public static final String CONTEXT_MANAGEMENT_FIELD = "context_management";
    private static final String LLM_INTERFACE_FIELD = "_llm_interface";
    private static final String TAG_VALUE_UNKNOWN = "unknown";
    private static final String TAG_MEMORY_TYPE = "memory_type";
    public static final int AGENT_NAME_MAX_LENGTH = 128;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT = CommonValue.VERSION_2_13_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_CONTEXT_MANAGEMENT = CommonValue.VERSION_3_5_0;
    private String name;
    private String type;
    private String description;
    private LLMSpec llm;
    private MLAgentModelSpec model;
    private List<MLToolSpec> tools;
    private Map<String, String> parameters;
    private MLMemorySpec memory;
    private Instant createdTime;
    private Instant lastUpdateTime;
    private String appType;
    private Boolean isHidden;
    private String contextManagementName;
    private ContextManagementTemplate contextManagement;
    private String tenantId;

    public MLAgent(String name, String type, String description, LLMSpec llm, MLAgentModelSpec model, List<MLToolSpec> tools, Map<String, String> parameters, MLMemorySpec memory, Instant createdTime, Instant lastUpdateTime, String appType, Boolean isHidden, String contextManagementName, ContextManagementTemplate contextManagement, String tenantId) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.llm = llm;
        this.model = model;
        this.tools = tools;
        this.parameters = parameters;
        this.memory = memory;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
        this.appType = appType;
        this.isHidden = isHidden;
        this.contextManagementName = contextManagementName;
        this.contextManagement = contextManagement;
        this.tenantId = tenantId;
        this.validate();
    }

    public MLAgent(String name, String type, String description, LLMSpec llm, List<MLToolSpec> tools, Map<String, String> parameters, MLMemorySpec memory, Instant createdTime, Instant lastUpdateTime, String appType, Boolean isHidden, String contextManagementName, ContextManagementTemplate contextManagement, String tenantId) {
        this(name, type, description, llm, null, tools, parameters, memory, createdTime, lastUpdateTime, appType, isHidden, contextManagementName, contextManagement, tenantId);
    }

    private void validate() {
        if (this.name == null) {
            throw new IllegalArgumentException("Agent name can't be null");
        }
        if (this.name.isBlank() || this.name.length() > 128) {
            throw new IllegalArgumentException(String.format("Agent name cannot be empty or exceed max length of %d characters", 128));
        }
        this.validateMLAgentType(this.type);
        if ((this.type.equalsIgnoreCase(MLAgentType.CONVERSATIONAL.toString()) || this.type.equalsIgnoreCase(MLAgentType.PLAN_EXECUTE_AND_REFLECT.toString())) && this.llm == null && this.model == null) {
            throw new IllegalArgumentException("We need model information for the conversational agent type");
        }
        HashSet<String> toolNames = new HashSet<String>();
        if (this.tools != null) {
            for (MLToolSpec toolSpec : this.tools) {
                String toolName = Optional.ofNullable(toolSpec.getName()).orElse(toolSpec.getType());
                if (toolNames.contains(toolName)) {
                    throw new IllegalArgumentException("Duplicate tool defined in agent configuration");
                }
                toolNames.add(toolName);
            }
        }
        this.validateContextManagement();
    }

    private void validateContextManagement() {
        if (this.contextManagementName != null && this.contextManagement != null) {
            throw new IllegalArgumentException("Cannot specify both context_management_name and context_management");
        }
        if (this.contextManagement != null && !this.contextManagement.isValid()) {
            throw new IllegalArgumentException("Invalid context management configuration");
        }
    }

    private void validateMLAgentType(String agentType) {
        if (this.type == null) {
            throw new IllegalArgumentException("Agent type can't be null");
        }
        try {
            MLAgentType.valueOf(agentType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Agent Type");
        }
    }

    public MLAgent(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readString();
        this.type = input.readString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.llm = new LLMSpec(input);
        }
        if (input.readBoolean()) {
            this.model = new MLAgentModelSpec(input);
        }
        if (input.readBoolean()) {
            this.tools = new ArrayList<MLToolSpec>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.tools.add(new MLToolSpec(input));
            }
        }
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        if (input.readBoolean()) {
            this.memory = new MLMemorySpec(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        this.appType = input.readOptionalString();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT)) {
            this.isHidden = input.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CONTEXT_MANAGEMENT)) {
            this.contextManagementName = input.readOptionalString();
            if (input.readBoolean()) {
                this.contextManagement = new ContextManagementTemplate(input);
            }
        }
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
        this.validate();
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeOptionalString(this.description);
        if (this.llm != null) {
            out.writeBoolean(true);
            this.llm.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.model != null) {
            out.writeBoolean(true);
            this.model.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            out.writeBoolean(true);
            out.writeInt(this.tools.size());
            for (MLToolSpec tool : this.tools) {
                tool.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        if (this.memory != null) {
            out.writeBoolean(true);
            this.memory.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.appType);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT)) {
            out.writeOptionalBoolean(this.isHidden);
        }
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CONTEXT_MANAGEMENT)) {
            out.writeOptionalString(this.contextManagementName);
            if (this.contextManagement != null) {
                out.writeBoolean(true);
                this.contextManagement.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public void removeCredential() {
        if (this.model != null) {
            this.model.removeCredential();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(AGENT_NAME_FIELD, this.name);
        }
        if (this.type != null) {
            builder.field(AGENT_TYPE_FIELD, this.type);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.llm != null) {
            builder.field(LLM_FIELD, (ToXContent)this.llm);
        }
        if (this.model != null) {
            builder.field(MODEL_FIELD, (ToXContent)this.model);
        }
        if (this.tools != null && this.tools.size() > 0) {
            builder.field(TOOLS_FIELD, this.tools);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        if (this.memory != null) {
            builder.field(MEMORY_FIELD, (ToXContent)this.memory);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.appType != null) {
            builder.field(APP_TYPE_FIELD, this.appType);
        }
        if (this.isHidden != null) {
            builder.field(IS_HIDDEN_FIELD, this.isHidden);
        }
        if (this.contextManagementName != null) {
            builder.field(CONTEXT_MANAGEMENT_NAME_FIELD, this.contextManagementName);
        }
        if (this.contextManagement != null) {
            builder.field(CONTEXT_MANAGEMENT_FIELD, (ToXContent)this.contextManagement);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLAgent parse(XContentParser parser) throws IOException {
        return MLAgent.parseCommonFields(parser, true);
    }

    public static MLAgent parseFromUserInput(XContentParser parser) throws IOException {
        return MLAgent.parseCommonFields(parser, false);
    }

    private static MLAgent parseCommonFields(XContentParser parser, boolean parseHidden) throws IOException {
        String name = null;
        String type = null;
        String description = null;
        LLMSpec llm = null;
        MLAgentModelSpec model = null;
        ArrayList<MLToolSpec> tools = null;
        Map<String, String> parameters = null;
        MLMemorySpec memory = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        String appType = null;
        boolean isHidden = false;
        String contextManagementName = null;
        ContextManagementTemplate contextManagement = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block34;
                }
                case "type": {
                    type = parser.text();
                    continue block34;
                }
                case "description": {
                    description = parser.text();
                    continue block34;
                }
                case "llm": {
                    llm = LLMSpec.parse(parser);
                    continue block34;
                }
                case "model": {
                    model = MLAgentModelSpec.parse(parser);
                    continue block34;
                }
                case "tools": {
                    tools = new ArrayList<MLToolSpec>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        tools.add(MLToolSpec.parse(parser));
                    }
                    continue block34;
                }
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block34;
                }
                case "memory": {
                    memory = MLMemorySpec.parse(parser);
                    continue block34;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "app_type": {
                    appType = parser.text();
                    continue block34;
                }
                case "is_hidden": {
                    if (!parseHidden) continue block34;
                    isHidden = parser.booleanValue();
                    continue block34;
                }
                case "context_management_name": {
                    contextManagementName = parser.text();
                    continue block34;
                }
                case "context_management": {
                    contextManagement = ContextManagementTemplate.parse(parser);
                    continue block34;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block34;
                }
            }
            parser.skipChildren();
        }
        return MLAgent.builder().name(name).type(type).description(description).llm(llm).model(model).tools(tools).parameters(parameters).memory(memory).createdTime(createdTime).lastUpdateTime(lastUpdateTime).appType(appType).isHidden(isHidden).contextManagementName(contextManagementName).contextManagement(contextManagement).tenantId(tenantId).build();
    }

    public static MLAgent fromStream(StreamInput in) throws IOException {
        return new MLAgent(in);
    }

    public Tags getTags() {
        Tags tags = Tags.create().addTag(IS_HIDDEN_FIELD, this.isHidden != null ? this.isHidden : false).addTag(AGENT_TYPE_FIELD, this.type != null ? this.type : TAG_VALUE_UNKNOWN);
        if (this.memory != null && this.memory.getType() != null) {
            tags.addTag(TAG_MEMORY_TYPE, this.memory.getType());
        }
        if (this.parameters != null && this.parameters.get(LLM_INTERFACE_FIELD) != null) {
            tags.addTag(LLM_INTERFACE_FIELD, this.parameters.get(LLM_INTERFACE_FIELD));
        }
        return tags;
    }

    public boolean hasContextManagement() {
        return this.contextManagementName != null || this.contextManagement != null;
    }

    public ContextManagementTemplate getInlineContextManagement() {
        return this.contextManagement;
    }

    public boolean hasContextManagementTemplate() {
        return this.contextManagementName != null;
    }

    public String getContextManagementTemplateName() {
        return this.contextManagementName;
    }

    @Generated
    public static MLAgentBuilder builder() {
        return new MLAgentBuilder();
    }

    @Generated
    public MLAgentBuilder toBuilder() {
        return new MLAgentBuilder().name(this.name).type(this.type).description(this.description).llm(this.llm).model(this.model).tools(this.tools).parameters(this.parameters).memory(this.memory).createdTime(this.createdTime).lastUpdateTime(this.lastUpdateTime).appType(this.appType).isHidden(this.isHidden).contextManagementName(this.contextManagementName).contextManagement(this.contextManagement).tenantId(this.tenantId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLAgent)) {
            return false;
        }
        MLAgent other = (MLAgent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isHidden = this.getIsHidden();
        Boolean other$isHidden = other.getIsHidden();
        if (this$isHidden == null ? other$isHidden != null : !((Object)this$isHidden).equals(other$isHidden)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LLMSpec this$llm = this.getLlm();
        LLMSpec other$llm = other.getLlm();
        if (this$llm == null ? other$llm != null : !((Object)this$llm).equals(other$llm)) {
            return false;
        }
        MLAgentModelSpec this$model = this.getModel();
        MLAgentModelSpec other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        List<MLToolSpec> this$tools = this.getTools();
        List<MLToolSpec> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        MLMemorySpec this$memory = this.getMemory();
        MLMemorySpec other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$appType = this.getAppType();
        String other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !this$appType.equals(other$appType)) {
            return false;
        }
        String this$contextManagementName = this.getContextManagementName();
        String other$contextManagementName = other.getContextManagementName();
        if (this$contextManagementName == null ? other$contextManagementName != null : !this$contextManagementName.equals(other$contextManagementName)) {
            return false;
        }
        ContextManagementTemplate this$contextManagement = this.getContextManagement();
        ContextManagementTemplate other$contextManagement = other.getContextManagement();
        if (this$contextManagement == null ? other$contextManagement != null : !((Object)this$contextManagement).equals(other$contextManagement)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLAgent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isHidden = this.getIsHidden();
        result = result * 59 + ($isHidden == null ? 43 : ((Object)$isHidden).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LLMSpec $llm = this.getLlm();
        result = result * 59 + ($llm == null ? 43 : ((Object)$llm).hashCode());
        MLAgentModelSpec $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        List<MLToolSpec> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        MLMemorySpec $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $appType = this.getAppType();
        result = result * 59 + ($appType == null ? 43 : $appType.hashCode());
        String $contextManagementName = this.getContextManagementName();
        result = result * 59 + ($contextManagementName == null ? 43 : $contextManagementName.hashCode());
        ContextManagementTemplate $contextManagement = this.getContextManagement();
        result = result * 59 + ($contextManagement == null ? 43 : ((Object)$contextManagement).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LLMSpec getLlm() {
        return this.llm;
    }

    @Generated
    public MLAgentModelSpec getModel() {
        return this.model;
    }

    @Generated
    public List<MLToolSpec> getTools() {
        return this.tools;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public MLMemorySpec getMemory() {
        return this.memory;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public String getAppType() {
        return this.appType;
    }

    @Generated
    public Boolean getIsHidden() {
        return this.isHidden;
    }

    @Generated
    public String getContextManagementName() {
        return this.contextManagementName;
    }

    @Generated
    public ContextManagementTemplate getContextManagement() {
        return this.contextManagement;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public static class MLAgentBuilder {
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private String description;
        @Generated
        private LLMSpec llm;
        @Generated
        private MLAgentModelSpec model;
        @Generated
        private List<MLToolSpec> tools;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private MLMemorySpec memory;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private String appType;
        @Generated
        private Boolean isHidden;
        @Generated
        private String contextManagementName;
        @Generated
        private ContextManagementTemplate contextManagement;
        @Generated
        private String tenantId;

        @Generated
        MLAgentBuilder() {
        }

        @Generated
        public MLAgentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLAgentBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLAgentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLAgentBuilder llm(LLMSpec llm) {
            this.llm = llm;
            return this;
        }

        @Generated
        public MLAgentBuilder model(MLAgentModelSpec model) {
            this.model = model;
            return this;
        }

        @Generated
        public MLAgentBuilder tools(List<MLToolSpec> tools) {
            this.tools = tools;
            return this;
        }

        @Generated
        public MLAgentBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public MLAgentBuilder memory(MLMemorySpec memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MLAgentBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLAgentBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLAgentBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Generated
        public MLAgentBuilder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        @Generated
        public MLAgentBuilder contextManagementName(String contextManagementName) {
            this.contextManagementName = contextManagementName;
            return this;
        }

        @Generated
        public MLAgentBuilder contextManagement(ContextManagementTemplate contextManagement) {
            this.contextManagement = contextManagement;
            return this;
        }

        @Generated
        public MLAgentBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLAgent build() {
            return new MLAgent(this.name, this.type, this.description, this.llm, this.model, this.tools, this.parameters, this.memory, this.createdTime, this.lastUpdateTime, this.appType, this.isHidden, this.contextManagementName, this.contextManagement, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLAgent.MLAgentBuilder(name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", llm=" + String.valueOf(this.llm) + ", model=" + String.valueOf(this.model) + ", tools=" + String.valueOf(this.tools) + ", parameters=" + String.valueOf(this.parameters) + ", memory=" + String.valueOf(this.memory) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", appType=" + this.appType + ", isHidden=" + this.isHidden + ", contextManagementName=" + this.contextManagementName + ", contextManagement=" + String.valueOf(this.contextManagement) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

