/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.round;

import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.round.Roundable;

@InternalApi
class BidirectionalLinearSearcher
implements Roundable {
    private final long[] ascending;
    private final long[] descending;

    BidirectionalLinearSearcher(long[] values, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("at least one value must be present");
        }
        int len = size + 1 >>> 1;
        this.ascending = new long[len];
        this.descending = new long[len];
        for (int i = 0; i < len; ++i) {
            this.ascending[i] = values[i];
            this.descending[i] = values[size - i - 1];
        }
    }

    @Override
    public long floor(long key) {
        int i;
        for (i = 0; i < this.ascending.length; ++i) {
            if (this.descending[i] <= key) {
                return this.descending[i];
            }
            if (this.ascending[i] <= key) continue;
            assert (i > 0) : "key must be greater than or equal to " + this.ascending[0];
            return this.ascending[i - 1];
        }
        return this.ascending[i - 1];
    }
}

