/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <QDebug>
#include <QProcess>
#include "authorityservice.h"
#include "brightnesshelper.h"
extern "C" {

#include <linux/types.h>
#include <fcntl.h>
#include <unistd.h>
}

AuthorityService::AuthorityService(QObject *parent) :
    QObject(parent)
{

}

int AuthorityService::isTrialMode()
{
    static int ret = 0xff;
    char *pAck = NULL;
    char CmdAck[256] = "";
    FILE * pPipe;

    if (ret != 0xff) {
        return ret;
    }

    pPipe = popen("cat /proc/cmdline","r");

    if (pPipe) {
        pAck = fgets(CmdAck, sizeof(CmdAck)-1, pPipe);
        if (strstr(CmdAck, "boot=casper")) {
            ret = true;
        } else{
            ret = false;
        }

        pclose(pPipe);
    } else {
        return false;
    }

    return ret;
}

int AuthorityService::setDynamicBrightness(bool state)
{
    int ret = false;
    char CmdAck[256] = "";
    FILE * pPipe;

    if (state) {
        pPipe = popen("gpioset gpiochip0 179=1","r");
    } else {
        pPipe = popen("gpioset gpiochip0 179=0","r");
    }
    //todo 需要读取设置
    if (pPipe) {
        fgets(CmdAck, sizeof(CmdAck)-1, pPipe);
        if (strnlen(CmdAck, 255) == 0) {
            ret = true;//有返回数据就是异常
        }

        pclose(pPipe);
    }

    return ret;
}

QString AuthorityService::popenCommand(QString cmd)
{
    char *pAck = NULL;
    char CmdAck[1024];
    FILE * pPipe;
    QString ret = "";
    //ef列出所有进程，|grep %s | 仅显示含%s的进程， |grep -v grep过滤掉含grep的进程（本条指令），|wc -l 查看行数

    pPipe = popen(cmd.toLatin1().data(),"r");
    if (pPipe) {
        pAck = fgets(CmdAck,sizeof(CmdAck),pPipe);
        ret = QString(CmdAck);
        pclose(pPipe);
    }

    return ret;
}

int AuthorityService::nightModeCanBeSet()
{
    static int ret = 0xff;
    QString VGAInfo = "";
    if (ret != 0xff) {
        return ret;
    }

    VGAInfo = popenCommand("lspci |grep VGA");
    qDebug()<<VGAInfo;

    if (VGAInfo != "") {
        ret = 1;
        Q_FOREACH(QString vga, m_NightModeBlackList) {
            if (VGAInfo.contains(vga)) {
                ret = 0;
                break;
            }
        }
    }
    return ret;
}


int AuthorityService::startColorService()
{
    QString cmd = QString("systemctl start geoclue");
    system(cmd.toLatin1().data());

    cmd = QString("systemctl start colord");
    system(cmd.toLatin1().data());
    return 0;
}


int AuthorityService::stopColorService()
{
    QString cmd = QString("systemctl stop geoclue");
    system(cmd.toLatin1().data());

    cmd = QString("systemctl stop colord");
    system(cmd.toLatin1().data());
    return 0;
}

