/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_rlda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42, tzk0;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  tzk0 = 0.2e1 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42, tzk0;

  double t43, t48, t49, t50, t51, t52, t54, t59;
  double t61, t65, tvrho0, tvsigma0, t70, t71, t73, t74;
  double t76, tvlapl0, t79, tvtau0;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  tzk0 = 0.2e1 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t28;
  t48 = t17 * t18 * params->prefactor;
  t49 = t22 * t24;
  t50 = t36 * t36;
  t51 = 0.1e1 / t50;
  t52 = rho[0] * rho[0];
  t54 = 0.1e1 / t28 / t52;
  t59 = -0.1e2 / 0.3e1 * t27 * t54 + 0.5e1 / 0.12e2 * t33 * t54;
  t61 = t49 * t51 * t59;
  t65 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t17 * t43 * t39 + 0.15e2 / 0.16e2 * t48 * t61);
  tvrho0 = 0.2e1 * rho[0] * t65 + 0.2e1 * t42;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t70 = 0.1e1 / t18 / rho[0] * params->prefactor;
  t71 = t17 * t70;
  t73 = t49 * t51 * t26;
  t74 = t71 * t73;
  t76 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t74);
  tvlapl0 = 0.2e1 * rho[0] * t76;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t79 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t74);
  tvtau0 = 0.2e1 * rho[0] * t79;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42, tzk0;

  double t43, t48, t49, t50, t51, t52, t54, t59;
  double t61, t65, tvrho0, tvsigma0, t70, t71, t73, t74;
  double t76, tvlapl0, t79, tvtau0;

  double t86, t90, t91, t93, t96, t98, t103, t105;
  double t109, tv2rho20, tv2rhosigma0, t115, t116, t118, t120, t121;
  double t124, tv2rholapl0, t130, tv2rhotau0, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t135;
  double t137, t138, t140, tv2lapl20, t143, tv2lapltau0, t146, tv2tau20;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  tzk0 = 0.2e1 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t28;
  t48 = t17 * t18 * params->prefactor;
  t49 = t22 * t24;
  t50 = t36 * t36;
  t51 = 0.1e1 / t50;
  t52 = rho[0] * rho[0];
  t54 = 0.1e1 / t28 / t52;
  t59 = -0.1e2 / 0.3e1 * t27 * t54 + 0.5e1 / 0.12e2 * t33 * t54;
  t61 = t49 * t51 * t59;
  t65 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t17 * t43 * t39 + 0.15e2 / 0.16e2 * t48 * t61);
  tvrho0 = 0.2e1 * rho[0] * t65 + 0.2e1 * t42;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t70 = 0.1e1 / t18 / rho[0] * params->prefactor;
  t71 = t17 * t70;
  t73 = t49 * t51 * t26;
  t74 = t71 * t73;
  t76 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t74);
  tvlapl0 = 0.2e1 * rho[0] * t76;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t79 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t74);
  tvtau0 = 0.2e1 * rho[0] * t79;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t86 = t17 * t43 * params->prefactor;
  t90 = 0.1e1 / t50 / t36;
  t91 = t59 * t59;
  t93 = t49 * t90 * t91;
  t96 = t52 * rho[0];
  t98 = 0.1e1 / t28 / t96;
  t103 = 0.8e2 / 0.9e1 * t27 * t98 - 0.1e2 / 0.9e1 * t33 * t98;
  t105 = t49 * t51 * t103;
  t109 = my_piecewise3(t3, 0, 0.5e1 / 0.24e2 * t17 * t30 * t39 + 0.5e1 / 0.8e1 * t86 * t61 - 0.15e2 / 0.8e1 * t48 * t93 + 0.15e2 / 0.16e2 * t48 * t105);
  tv2rho20 = 0.2e1 * rho[0] * t109 + 0.4e1 * t65;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t115 = t17 / t18 / t52 * params->prefactor;
  t116 = t115 * t73;
  t118 = t90 * t26;
  t120 = t49 * t118 * t59;
  t121 = t71 * t120;
  t124 = my_piecewise3(t3, 0, 0.5e1 / 0.16e2 * t116 + 0.15e2 / 0.32e2 * t121);
  tv2rholapl0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t76;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t130 = my_piecewise3(t3, 0, -0.5e1 / 0.2e1 * t116 - 0.15e2 / 0.4e1 * t121);
  tv2rhotau0 = 0.2e1 * rho[0] * t130 + 0.2e1 * t79;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t135 = t17 / t96 * params->prefactor;
  t137 = t49 * t90 * t25;
  t138 = t135 * t137;
  t140 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t138);
  tv2lapl20 = 0.2e1 * rho[0] * t140;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t143 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t138);
  tv2lapltau0 = 0.2e1 * rho[0] * t143;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t146 = my_piecewise3(t3, 0, -0.15e2 * t138);
  tv2tau20 = 0.2e1 * rho[0] * t146;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42, tzk0;

  double t43, t48, t49, t50, t51, t52, t54, t59;
  double t61, t65, tvrho0, tvsigma0, t70, t71, t73, t74;
  double t76, tvlapl0, t79, tvtau0;

  double t86, t90, t91, t93, t96, t98, t103, t105;
  double t109, tv2rho20, tv2rhosigma0, t115, t116, t118, t120, t121;
  double t124, tv2rholapl0, t130, tv2rhotau0, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t135;
  double t137, t138, t140, tv2lapl20, t143, tv2lapltau0, t146, tv2tau20;

  double t153, t160, t161, t162, t164, t167, t169, t172;
  double t174, t179, t181, t185, tv3rho30, tv3rho2sigma0, t192, t193;
  double t195, t199, t200, t203, t204, t207, tv3rho2lapl0, t216;
  double tv3rho2tau0, tv3rhosigma20, tv3rhosigmalapl0, tv3rhosigmatau0, t221, t223, t225, t227;
  double t229, tv3rholapl20, t234, tv3rholapltau0, t238, tv3rhotau20, tv3sigma30, tv3sigma2lapl0;
  double tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t242, t243, t244, t246;
  double tv3lapl30, t249, tv3lapl2tau0, t252, tv3lapltau20, t255, tv3tau30;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  tzk0 = 0.2e1 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t28;
  t48 = t17 * t18 * params->prefactor;
  t49 = t22 * t24;
  t50 = t36 * t36;
  t51 = 0.1e1 / t50;
  t52 = rho[0] * rho[0];
  t54 = 0.1e1 / t28 / t52;
  t59 = -0.1e2 / 0.3e1 * t27 * t54 + 0.5e1 / 0.12e2 * t33 * t54;
  t61 = t49 * t51 * t59;
  t65 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t17 * t43 * t39 + 0.15e2 / 0.16e2 * t48 * t61);
  tvrho0 = 0.2e1 * rho[0] * t65 + 0.2e1 * t42;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t70 = 0.1e1 / t18 / rho[0] * params->prefactor;
  t71 = t17 * t70;
  t73 = t49 * t51 * t26;
  t74 = t71 * t73;
  t76 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t74);
  tvlapl0 = 0.2e1 * rho[0] * t76;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t79 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t74);
  tvtau0 = 0.2e1 * rho[0] * t79;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t86 = t17 * t43 * params->prefactor;
  t90 = 0.1e1 / t50 / t36;
  t91 = t59 * t59;
  t93 = t49 * t90 * t91;
  t96 = t52 * rho[0];
  t98 = 0.1e1 / t28 / t96;
  t103 = 0.8e2 / 0.9e1 * t27 * t98 - 0.1e2 / 0.9e1 * t33 * t98;
  t105 = t49 * t51 * t103;
  t109 = my_piecewise3(t3, 0, 0.5e1 / 0.24e2 * t17 * t30 * t39 + 0.5e1 / 0.8e1 * t86 * t61 - 0.15e2 / 0.8e1 * t48 * t93 + 0.15e2 / 0.16e2 * t48 * t105);
  tv2rho20 = 0.2e1 * rho[0] * t109 + 0.4e1 * t65;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t115 = t17 / t18 / t52 * params->prefactor;
  t116 = t115 * t73;
  t118 = t90 * t26;
  t120 = t49 * t118 * t59;
  t121 = t71 * t120;
  t124 = my_piecewise3(t3, 0, 0.5e1 / 0.16e2 * t116 + 0.15e2 / 0.32e2 * t121);
  tv2rholapl0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t76;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t130 = my_piecewise3(t3, 0, -0.5e1 / 0.2e1 * t116 - 0.15e2 / 0.4e1 * t121);
  tv2rhotau0 = 0.2e1 * rho[0] * t130 + 0.2e1 * t79;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t135 = t17 / t96 * params->prefactor;
  t137 = t49 * t90 * t25;
  t138 = t135 * t137;
  t140 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t138);
  tv2lapl20 = 0.2e1 * rho[0] * t140;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t143 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t138);
  tv2lapltau0 = 0.2e1 * rho[0] * t143;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t146 = my_piecewise3(t3, 0, -0.15e2 * t138);
  tv2tau20 = 0.2e1 * rho[0] * t146;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t153 = t17 * t30 * params->prefactor;
  t160 = t50 * t50;
  t161 = 0.1e1 / t160;
  t162 = t91 * t59;
  t164 = t49 * t161 * t162;
  t167 = t90 * t59;
  t169 = t49 * t167 * t103;
  t172 = t52 * t52;
  t174 = 0.1e1 / t28 / t172;
  t179 = -0.88e3 / 0.27e2 * t27 * t174 + 0.11e3 / 0.27e2 * t33 * t174;
  t181 = t49 * t51 * t179;
  t185 = my_piecewise3(t3, 0, -0.25e2 / 0.72e2 * t17 * t54 * t39 - 0.5e1 / 0.8e1 * t153 * t61 - 0.15e2 / 0.8e1 * t86 * t93 + 0.15e2 / 0.16e2 * t86 * t105 + 0.45e2 / 0.8e1 * t48 * t164 - 0.45e2 / 0.8e1 * t48 * t169 + 0.15e2 / 0.16e2 * t48 * t181);
  tv3rho30 = 0.2e1 * rho[0] * t185 + 0.6e1 * t109;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho2sigma0 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t192 = t17 / t18 / t96 * params->prefactor;
  t193 = t192 * t73;
  t195 = t115 * t120;
  t199 = t49 * t161 * t26 * t91;
  t200 = t71 * t199;
  t203 = t49 * t118 * t103;
  t204 = t71 * t203;
  t207 = my_piecewise3(t3, 0, -0.35e2 / 0.48e2 * t193 - 0.5e1 / 0.4e1 * t195 - 0.45e2 / 0.32e2 * t200 + 0.15e2 / 0.32e2 * t204);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t207 + 0.4e1 * t124;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t216 = my_piecewise3(t3, 0, 0.35e2 / 0.6e1 * t193 + 0.1e2 * t195 + 0.45e2 / 0.4e1 * t200 - 0.15e2 / 0.4e1 * t204);
  tv3rho2tau0 = 0.2e1 * rho[0] * t216 + 0.4e1 * t130;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t221 = t17 / t172 * params->prefactor;
  t223 = t161 * t25;
  t225 = t49 * t223 * t59;
  t227 = t135 * t225 + t221 * t137;
  t229 = my_piecewise3(t3, 0, 0.45e2 / 0.64e2 * t227);
  tv3rholapl20 = 0.2e1 * rho[0] * t229 + 0.2e1 * t140;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t234 = my_piecewise3(t3, 0, -0.45e2 / 0.8e1 * t227);
  tv3rholapltau0 = 0.2e1 * rho[0] * t234 + 0.2e1 * t143;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t238 = my_piecewise3(t3, 0, 0.45e2 * t227);
  tv3rhotau20 = 0.2e1 * rho[0] * t238 + 0.2e1 * t146;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t242 = t24 * t161;
  t243 = t23 * t242;
  t244 = t17 * t174 * t243;
  t246 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t244);
  tv3lapl30 = 0.2e1 * rho[0] * t246;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t249 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t244);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t249;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t252 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t244);
  tv3lapltau20 = 0.2e1 * rho[0] * t252;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t255 = my_piecewise3(t3, 0, 0.18e3 * t244);
  tv3tau30 = 0.2e1 * rho[0] * t255;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42, tzk0;

  double t43, t48, t49, t50, t51, t52, t54, t59;
  double t61, t65, tvrho0, tvsigma0, t70, t71, t73, t74;
  double t76, tvlapl0, t79, tvtau0;

  double t86, t90, t91, t93, t96, t98, t103, t105;
  double t109, tv2rho20, tv2rhosigma0, t115, t116, t118, t120, t121;
  double t124, tv2rholapl0, t130, tv2rhotau0, tv2sigma20, tv2sigmalapl0, tv2sigmatau0, t135;
  double t137, t138, t140, tv2lapl20, t143, tv2lapltau0, t146, tv2tau20;

  double t153, t160, t161, t162, t164, t167, t169, t172;
  double t174, t179, t181, t185, tv3rho30, tv3rho2sigma0, t192, t193;
  double t195, t199, t200, t203, t204, t207, tv3rho2lapl0, t216;
  double tv3rho2tau0, tv3rhosigma20, tv3rhosigmalapl0, tv3rhosigmatau0, t221, t223, t225, t227;
  double t229, tv3rholapl20, t234, tv3rholapltau0, t238, tv3rhotau20, tv3sigma30, tv3sigma2lapl0;
  double tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t242, t243, t244, t246;
  double tv3lapl30, t249, tv3lapl2tau0, t252, tv3lapltau20, t255, tv3tau30;

  double t276, t277, t287, t296, t298, t308, t309, tv4rho40;
  double tv4rho3sigma0, t317, t319, t321, t323, t325, t328, t335;
  double t339, t342, tv4rho3lapl0, t354, tv4rho3tau0, tv4rho2sigma20, tv4rho2sigmalapl0, tv4rho2sigmatau0;
  double t361, t363, t368, t372, t375, tv4rho2lapl20, t384, tv4rho2lapltau0;
  double t393, tv4rho2tau20, tv4rhosigma30, tv4rhosigma2lapl0, tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20;
  double t397, t403, t406, tv4rholapl30, t412, tv4rholapl2tau0, t418, tv4rholapltau20;
  double t424, tv4rhotau30, tv4sigma40, tv4sigma3lapl0, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20;
  double tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t433, t435, tv4lapl40, t438;
  double tv4lapl3tau0, t441, tv4lapl2tau20, t444, tv4lapltau30, t447, tv4tau40;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  tzk0 = 0.2e1 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t28;
  t48 = t17 * t18 * params->prefactor;
  t49 = t22 * t24;
  t50 = t36 * t36;
  t51 = 0.1e1 / t50;
  t52 = rho[0] * rho[0];
  t54 = 0.1e1 / t28 / t52;
  t59 = -0.1e2 / 0.3e1 * t27 * t54 + 0.5e1 / 0.12e2 * t33 * t54;
  t61 = t49 * t51 * t59;
  t65 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t17 * t43 * t39 + 0.15e2 / 0.16e2 * t48 * t61);
  tvrho0 = 0.2e1 * rho[0] * t65 + 0.2e1 * t42;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t70 = 0.1e1 / t18 / rho[0] * params->prefactor;
  t71 = t17 * t70;
  t73 = t49 * t51 * t26;
  t74 = t71 * t73;
  t76 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t74);
  tvlapl0 = 0.2e1 * rho[0] * t76;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t79 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t74);
  tvtau0 = 0.2e1 * rho[0] * t79;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t86 = t17 * t43 * params->prefactor;
  t90 = 0.1e1 / t50 / t36;
  t91 = t59 * t59;
  t93 = t49 * t90 * t91;
  t96 = t52 * rho[0];
  t98 = 0.1e1 / t28 / t96;
  t103 = 0.8e2 / 0.9e1 * t27 * t98 - 0.1e2 / 0.9e1 * t33 * t98;
  t105 = t49 * t51 * t103;
  t109 = my_piecewise3(t3, 0, 0.5e1 / 0.24e2 * t17 * t30 * t39 + 0.5e1 / 0.8e1 * t86 * t61 - 0.15e2 / 0.8e1 * t48 * t93 + 0.15e2 / 0.16e2 * t48 * t105);
  tv2rho20 = 0.2e1 * rho[0] * t109 + 0.4e1 * t65;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t115 = t17 / t18 / t52 * params->prefactor;
  t116 = t115 * t73;
  t118 = t90 * t26;
  t120 = t49 * t118 * t59;
  t121 = t71 * t120;
  t124 = my_piecewise3(t3, 0, 0.5e1 / 0.16e2 * t116 + 0.15e2 / 0.32e2 * t121);
  tv2rholapl0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t76;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t130 = my_piecewise3(t3, 0, -0.5e1 / 0.2e1 * t116 - 0.15e2 / 0.4e1 * t121);
  tv2rhotau0 = 0.2e1 * rho[0] * t130 + 0.2e1 * t79;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t135 = t17 / t96 * params->prefactor;
  t137 = t49 * t90 * t25;
  t138 = t135 * t137;
  t140 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t138);
  tv2lapl20 = 0.2e1 * rho[0] * t140;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t143 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t138);
  tv2lapltau0 = 0.2e1 * rho[0] * t143;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t146 = my_piecewise3(t3, 0, -0.15e2 * t138);
  tv2tau20 = 0.2e1 * rho[0] * t146;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t153 = t17 * t30 * params->prefactor;
  t160 = t50 * t50;
  t161 = 0.1e1 / t160;
  t162 = t91 * t59;
  t164 = t49 * t161 * t162;
  t167 = t90 * t59;
  t169 = t49 * t167 * t103;
  t172 = t52 * t52;
  t174 = 0.1e1 / t28 / t172;
  t179 = -0.88e3 / 0.27e2 * t27 * t174 + 0.11e3 / 0.27e2 * t33 * t174;
  t181 = t49 * t51 * t179;
  t185 = my_piecewise3(t3, 0, -0.25e2 / 0.72e2 * t17 * t54 * t39 - 0.5e1 / 0.8e1 * t153 * t61 - 0.15e2 / 0.8e1 * t86 * t93 + 0.15e2 / 0.16e2 * t86 * t105 + 0.45e2 / 0.8e1 * t48 * t164 - 0.45e2 / 0.8e1 * t48 * t169 + 0.15e2 / 0.16e2 * t48 * t181);
  tv3rho30 = 0.2e1 * rho[0] * t185 + 0.6e1 * t109;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  tv3rho2sigma0 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t192 = t17 / t18 / t96 * params->prefactor;
  t193 = t192 * t73;
  t195 = t115 * t120;
  t199 = t49 * t161 * t26 * t91;
  t200 = t71 * t199;
  t203 = t49 * t118 * t103;
  t204 = t71 * t203;
  t207 = my_piecewise3(t3, 0, -0.35e2 / 0.48e2 * t193 - 0.5e1 / 0.4e1 * t195 - 0.45e2 / 0.32e2 * t200 + 0.15e2 / 0.32e2 * t204);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t207 + 0.4e1 * t124;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t216 = my_piecewise3(t3, 0, 0.35e2 / 0.6e1 * t193 + 0.1e2 * t195 + 0.45e2 / 0.4e1 * t200 - 0.15e2 / 0.4e1 * t204);
  tv3rho2tau0 = 0.2e1 * rho[0] * t216 + 0.4e1 * t130;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t221 = t17 / t172 * params->prefactor;
  t223 = t161 * t25;
  t225 = t49 * t223 * t59;
  t227 = t135 * t225 + t221 * t137;
  t229 = my_piecewise3(t3, 0, 0.45e2 / 0.64e2 * t227);
  tv3rholapl20 = 0.2e1 * rho[0] * t229 + 0.2e1 * t140;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t234 = my_piecewise3(t3, 0, -0.45e2 / 0.8e1 * t227);
  tv3rholapltau0 = 0.2e1 * rho[0] * t234 + 0.2e1 * t143;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t238 = my_piecewise3(t3, 0, 0.45e2 * t227);
  tv3rhotau20 = 0.2e1 * rho[0] * t238 + 0.2e1 * t146;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t242 = t24 * t161;
  t243 = t23 * t242;
  t244 = t17 * t174 * t243;
  t246 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t244);
  tv3lapl30 = 0.2e1 * rho[0] * t246;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t249 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t244);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t249;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t252 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t244);
  tv3lapltau20 = 0.2e1 * rho[0] * t252;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t255 = my_piecewise3(t3, 0, 0.18e3 * t244);
  tv3tau30 = 0.2e1 * rho[0] * t255;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t276 = 0.1e1 / t160 / t36;
  t277 = t91 * t91;
  t287 = t103 * t103;
  t296 = t172 * rho[0];
  t298 = 0.1e1 / t28 / t296;
  t308 = 0.25e2 / 0.27e2 * t17 * t98 * t39 + 0.25e2 / 0.18e2 * t17 * t54 * params->prefactor * t61 + 0.5e1 / 0.2e1 * t153 * t93 - 0.5e1 / 0.4e1 * t153 * t105 + 0.15e2 / 0.2e1 * t86 * t164 - 0.15e2 / 0.2e1 * t86 * t169 + 0.5e1 / 0.4e1 * t86 * t181 - 0.45e2 / 0.2e1 * t48 * t49 * t276 * t277 + 0.135e3 / 0.4e1 * t48 * t49 * t161 * t91 * t103 - 0.45e2 / 0.8e1 * t48 * t49 * t90 * t287 - 0.15e2 / 0.2e1 * t48 * t49 * t167 * t179 + 0.15e2 / 0.16e2 * t48 * t49 * t51 * (0.1232e5 / 0.81e2 * t27 * t298 - 0.154e4 / 0.81e2 * t33 * t298);
  t309 = my_piecewise3(t3, 0, t308);
  tv4rho40 = 0.2e1 * rho[0] * t309 + 0.8e1 * t185;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  tv4rho3sigma0 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t317 = t17 / t18 / t172 * params->prefactor * t73;
  t319 = t192 * t120;
  t321 = t115 * t199;
  t323 = t115 * t203;
  t325 = t276 * t26;
  t328 = t71 * t49 * t325 * t162;
  t335 = t17 * t70 * t22 * t242 * t26 * t59 * t103;
  t339 = t71 * t49 * t118 * t179;
  t342 = my_piecewise3(t3, 0, 0.175e3 / 0.72e2 * t317 + 0.35e2 / 0.8e1 * t319 + 0.45e2 / 0.8e1 * t321 - 0.15e2 / 0.8e1 * t323 + 0.45e2 / 0.8e1 * t328 - 0.135e3 / 0.32e2 * t335 + 0.15e2 / 0.32e2 * t339);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t342 + 0.6e1 * t207;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t354 = my_piecewise3(t3, 0, -0.175e3 / 0.9e1 * t317 - 0.35e2 * t319 - 0.45e2 * t321 + 0.15e2 * t323 - 0.45e2 * t328 + 0.135e3 / 0.4e1 * t335 - 0.15e2 / 0.4e1 * t339);
  tv4rho3tau0 = 0.2e1 * rho[0] * t354 + 0.6e1 * t216;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t361 = t17 / t296 * params->prefactor * t137;
  t363 = t221 * t225;
  t368 = t135 * t49 * t276 * t25 * t91;
  t372 = t135 * t49 * t223 * t103;
  t375 = my_piecewise3(t3, 0, -0.45e2 / 0.16e2 * t361 - 0.135e3 / 0.32e2 * t363 - 0.45e2 / 0.16e2 * t368 + 0.45e2 / 0.64e2 * t372);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t375 + 0.4e1 * t229;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  t384 = my_piecewise3(t3, 0, 0.45e2 / 0.2e1 * t361 + 0.135e3 / 0.4e1 * t363 + 0.45e2 / 0.2e1 * t368 - 0.45e2 / 0.8e1 * t372);
  tv4rho2lapltau0 = 0.2e1 * rho[0] * t384 + 0.4e1 * t234;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t393 = my_piecewise3(t3, 0, -0.18e3 * t361 - 0.27e3 * t363 - 0.18e3 * t368 + 0.45e2 * t372);
  tv4rho2tau20 = 0.2e1 * rho[0] * t393 + 0.4e1 * t238;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t397 = t17 * t298 * t243;
  t403 = t17 * t174 * params->prefactor * t49 * t276 * t59;
  t406 = my_piecewise3(t3, 0, 0.105e3 / 0.64e2 * t397 + 0.45e2 / 0.32e2 * t403);
  tv4rholapl30 = 0.2e1 * rho[0] * t406 + 0.2e1 * t246;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  t412 = my_piecewise3(t3, 0, -0.105e3 / 0.8e1 * t397 - 0.45e2 / 0.4e1 * t403);
  tv4rholapl2tau0 = 0.2e1 * rho[0] * t412 + 0.2e1 * t249;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  t418 = my_piecewise3(t3, 0, 0.105e3 * t397 + 0.9e2 * t403);
  tv4rholapltau20 = 0.2e1 * rho[0] * t418 + 0.2e1 * t252;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t424 = my_piecewise3(t3, 0, -0.84e3 * t397 - 0.72e3 * t403);
  tv4rhotau30 = 0.2e1 * rho[0] * t424 + 0.2e1 * t255;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t433 = t17 / t18 / t172 / t52 * params->prefactor * t49 * t325;
  t435 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t433);
  tv4lapl40 = 0.2e1 * rho[0] * t435;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  t438 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t433);
  tv4lapl3tau0 = 0.2e1 * rho[0] * t438;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  t441 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t433);
  tv4lapl2tau20 = 0.2e1 * rho[0] * t441;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  t444 = my_piecewise3(t3, 0, 0.18e3 * t433);
  tv4lapltau30 = 0.2e1 * rho[0] * t444;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t447 = my_piecewise3(t3, 0, -0.144e4 * t433);
  tv4tau40 = 0.2e1 * rho[0] * t447;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73, tzk0;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t92, t93, t94, t95, t96, t98;
  double t103, t105, t109, t110, t112, t115, t116, t122;
  double t124, tvrho0, t128, t131, t132, t137, t139, t142;
  double t143, t147, t148, t149, t150, t152, t157, t159;
  double t163, tvrho1, tvsigma0, tvsigma1, tvsigma2, t167, t168, t170;
  double tvlapl0, t172, t173, t175, tvlapl1, t177, tvtau0, t179;
  double tvtau1;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t90 = 0.5e1 / 0.16e2 * t25 * t87 * t44;
  t91 = t26 * params->prefactor;
  t92 = t25 * t91;
  t93 = t30 * t32;
  t94 = t41 * t41;
  t95 = 0.1e1 / t94;
  t96 = rho[0] * rho[0];
  t98 = 0.1e1 / t34 / t96;
  t103 = -0.1e2 / 0.3e1 * tau[0] * t98 + 0.5e1 / 0.12e2 * lapl[0] * t98;
  t105 = t93 * t95 * t103;
  t109 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t82 * t26 * t44 - t90 + 0.15e2 / 0.16e2 * t92 * t105);
  t110 = t49 * t75;
  t112 = my_piecewise5(t13, 0, t9, 0, -t6 - t110);
  t115 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t112);
  t116 = t4 * t115;
  t122 = 0.5e1 / 0.16e2 * t57 * t87 * t70;
  t124 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t116 * t26 * t70 - t122);
  tvrho0 = t47 + t73 + t5 * (t109 + t124);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t128 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t131 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t128);
  t132 = t4 * t131;
  t137 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t132 * t26 * t44 - t90);
  t139 = my_piecewise5(t13, 0, t9, 0, t6 - t110);
  t142 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t139);
  t143 = t4 * t142;
  t147 = t57 * t91;
  t148 = t67 * t67;
  t149 = 0.1e1 / t148;
  t150 = rho[1] * rho[1];
  t152 = 0.1e1 / t60 / t150;
  t157 = -0.1e2 / 0.3e1 * tau[1] * t152 + 0.5e1 / 0.12e2 * lapl[1] * t152;
  t159 = t93 * t149 * t157;
  t163 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t143 * t26 * t70 - t122 + 0.15e2 / 0.16e2 * t147 * t159);
  tvrho1 = t47 + t73 + t5 * (t137 + t163);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t167 = t93 * t95 * t36;
  t168 = t92 * t167;
  t170 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t168);
  tvlapl0 = t5 * t170;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t172 = t93 * t149 * t62;
  t173 = t147 * t172;
  t175 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t173);
  tvlapl1 = t5 * t175;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t168);
  tvtau0 = t5 * t177;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t179 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t173);
  tvtau1 = t5 * t179;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t92, t93, t94, t95, t96, t98;
  double t103, t105, t109, t110, t112, t115, t116, t122;
  double t124, tvrho0, t128, t131, t132, t137, t139, t142;
  double t143, t147, t148, t149, t150, t152, t157, t159;
  double t163, tvrho1, tvsigma0, tvsigma1, tvsigma2, t167, t168, t170;
  double tvlapl0, t172, t173, t175, tvlapl1, t177, tvtau0, t179;
  double tvtau1;

  double t182, t183, t184, t187, t188, t189, t192, t196;
  double t197, t202, t204, t208, t211, t212, t213, t214;
  double t217, t218, t220, t223, t225, t230, t232, t236;
  double t237, t238, t239, t242, t245, t249, t250, t255;
  double t259, t261, tv2rho20, t264, t268, t272, t273, t278;
  double t280, t286, t287, t291, t295, t296, t301, t304;
  double t307, t308, t311, tv2rho21, t316, t321, t325, t326;
  double t332, t333, t338, t342, t343, t348, t353, t354;
  double t356, t359, t361, t366, t368, t372, tv2rho22, tv2rhosigma0;
  double tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t375, t377, t378;
  double t379, t381, t382, t385, t386, t389, tv2rholapl0, t391;
  double t393, t394, t396, tv2rholapl1, t398, t401, tv2rholapl2, t403;
  double t405, t407, t408, t411, t412, t415, tv2rholapl3, t418;
  double t422, tv2rhotau0, t425, t427, tv2rhotau1, t431, tv2rhotau2, t437;
  double tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0;
  double tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t440, t442, t443, t445, tv2lapl20;
  double tv2lapl21, t447, t449, t450, t452, tv2lapl22, t454, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t456, tv2lapltau3, t458, tv2tau20, tv2tau21, t460;
  double tv2tau22;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t90 = 0.5e1 / 0.16e2 * t25 * t87 * t44;
  t91 = t26 * params->prefactor;
  t92 = t25 * t91;
  t93 = t30 * t32;
  t94 = t41 * t41;
  t95 = 0.1e1 / t94;
  t96 = rho[0] * rho[0];
  t98 = 0.1e1 / t34 / t96;
  t103 = -0.1e2 / 0.3e1 * tau[0] * t98 + 0.5e1 / 0.12e2 * lapl[0] * t98;
  t105 = t93 * t95 * t103;
  t109 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t82 * t26 * t44 - t90 + 0.15e2 / 0.16e2 * t92 * t105);
  t110 = t49 * t75;
  t112 = my_piecewise5(t13, 0, t9, 0, -t6 - t110);
  t115 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t112);
  t116 = t4 * t115;
  t122 = 0.5e1 / 0.16e2 * t57 * t87 * t70;
  t124 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t116 * t26 * t70 - t122);
  tvrho0 = t47 + t73 + t5 * (t109 + t124);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t128 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t131 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t128);
  t132 = t4 * t131;
  t137 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t132 * t26 * t44 - t90);
  t139 = my_piecewise5(t13, 0, t9, 0, t6 - t110);
  t142 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t139);
  t143 = t4 * t142;
  t147 = t57 * t91;
  t148 = t67 * t67;
  t149 = 0.1e1 / t148;
  t150 = rho[1] * rho[1];
  t152 = 0.1e1 / t60 / t150;
  t157 = -0.1e2 / 0.3e1 * tau[1] * t152 + 0.5e1 / 0.12e2 * lapl[1] * t152;
  t159 = t93 * t149 * t157;
  t163 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t143 * t26 * t70 - t122 + 0.15e2 / 0.16e2 * t147 * t159);
  tvrho1 = t47 + t73 + t5 * (t137 + t163);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t167 = t93 * t95 * t36;
  t168 = t92 * t167;
  t170 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t168);
  tvlapl0 = t5 * t170;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t172 = t93 * t149 * t62;
  t173 = t147 * t172;
  t175 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t173);
  tvlapl1 = t5 * t175;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t168);
  tvtau0 = t5 * t177;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t179 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t173);
  tvtau1 = t5 * t179;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t182 = t22 * t22;
  t183 = 0.1e1 / t182;
  t184 = t78 * t78;
  t187 = t74 * t5;
  t188 = 0.1e1 / t187;
  t189 = t15 * t188;
  t192 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t189);
  t196 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t184 + 0.4e1 / 0.3e1 * t22 * t192);
  t197 = t4 * t196;
  t202 = t82 * t87 * t44;
  t204 = t82 * t91;
  t208 = 0.1e1 / t86 / t5;
  t211 = 0.5e1 / 0.24e2 * t25 * t208 * t44;
  t212 = t87 * params->prefactor;
  t213 = t25 * t212;
  t214 = t213 * t105;
  t217 = 0.1e1 / t94 / t41;
  t218 = t103 * t103;
  t220 = t93 * t217 * t218;
  t223 = t96 * rho[0];
  t225 = 0.1e1 / t34 / t223;
  t230 = 0.8e2 / 0.9e1 * tau[0] * t225 - 0.1e2 / 0.9e1 * lapl[0] * t225;
  t232 = t93 * t95 * t230;
  t236 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t197 * t26 * t44 - 0.5e1 / 0.8e1 * t202 + 0.15e2 / 0.8e1 * t204 * t105 + t211 + 0.5e1 / 0.8e1 * t214 - 0.15e2 / 0.8e1 * t92 * t220 + 0.15e2 / 0.16e2 * t92 * t232);
  t237 = t54 * t54;
  t238 = 0.1e1 / t237;
  t239 = t112 * t112;
  t242 = t49 * t188;
  t245 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t242);
  t249 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t54 * t245);
  t250 = t4 * t249;
  t255 = t116 * t87 * t70;
  t259 = 0.5e1 / 0.24e2 * t57 * t208 * t70;
  t261 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t250 * t26 * t70 - 0.5e1 / 0.8e1 * t255 + t259);
  tv2rho20 = 0.2e1 * t109 + 0.2e1 * t124 + t5 * (t236 + t261);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t264 = t183 * t128;
  t268 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t189);
  t272 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t264 * t78 + 0.4e1 / 0.3e1 * t22 * t268);
  t273 = t4 * t272;
  t278 = t132 * t87 * t44;
  t280 = t132 * t91;
  t286 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t273 * t26 * t44 - 0.5e1 / 0.16e2 * t278 + 0.15e2 / 0.16e2 * t280 * t105 - 0.5e1 / 0.16e2 * t202 + t211 + 0.5e1 / 0.16e2 * t214);
  t287 = t238 * t139;
  t291 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t242);
  t295 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t287 * t112 + 0.4e1 / 0.3e1 * t54 * t291);
  t296 = t4 * t295;
  t301 = t143 * t87 * t70;
  t304 = t116 * t91;
  t307 = t57 * t212;
  t308 = t307 * t159;
  t311 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t296 * t26 * t70 - 0.5e1 / 0.16e2 * t301 - 0.5e1 / 0.16e2 * t255 + t259 + 0.15e2 / 0.16e2 * t304 * t159 + 0.5e1 / 0.16e2 * t308);
  tv2rho21 = t109 + t124 + t137 + t163 + t5 * (t286 + t311);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t316 = t128 * t128;
  t321 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t189);
  t325 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t316 + 0.4e1 / 0.3e1 * t22 * t321);
  t326 = t4 * t325;
  t332 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t326 * t26 * t44 - 0.5e1 / 0.8e1 * t278 + t211);
  t333 = t139 * t139;
  t338 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t242);
  t342 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t333 + 0.4e1 / 0.3e1 * t54 * t338);
  t343 = t4 * t342;
  t348 = t143 * t91;
  t353 = 0.1e1 / t148 / t67;
  t354 = t157 * t157;
  t356 = t93 * t353 * t354;
  t359 = t150 * rho[1];
  t361 = 0.1e1 / t60 / t359;
  t366 = 0.8e2 / 0.9e1 * tau[1] * t361 - 0.1e2 / 0.9e1 * lapl[1] * t361;
  t368 = t93 * t149 * t366;
  t372 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t343 * t26 * t70 - 0.5e1 / 0.8e1 * t301 + 0.15e2 / 0.8e1 * t348 * t159 + t259 + 0.5e1 / 0.8e1 * t308 - 0.15e2 / 0.8e1 * t147 * t356 + 0.15e2 / 0.16e2 * t147 * t368);
  tv2rho22 = 0.2e1 * t137 + 0.2e1 * t163 + t5 * (t332 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t375 = t204 * t167;
  t377 = t213 * t167;
  t378 = 0.5e1 / 0.64e2 * t377;
  t379 = t217 * t36;
  t381 = t93 * t379 * t103;
  t382 = t92 * t381;
  t385 = t93 * t95 * t98;
  t386 = t92 * t385;
  t389 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t375 - t378 + 0.15e2 / 0.32e2 * t382 + 0.25e2 / 0.64e2 * t386);
  tv2rholapl0 = t5 * t389 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t391 = t304 * t172;
  t393 = t307 * t172;
  t394 = 0.5e1 / 0.64e2 * t393;
  t396 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t391 - t394);
  tv2rholapl1 = t5 * t396 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t398 = t280 * t167;
  t401 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t398 - t378);
  tv2rholapl2 = t5 * t401 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t403 = t348 * t172;
  t405 = t353 * t62;
  t407 = t93 * t405 * t157;
  t408 = t147 * t407;
  t411 = t93 * t149 * t152;
  t412 = t147 * t411;
  t415 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t403 - t394 + 0.15e2 / 0.32e2 * t408 + 0.25e2 / 0.64e2 * t412);
  tv2rholapl3 = t5 * t415 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t418 = 0.5e1 / 0.8e1 * t377;
  t422 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t375 + t418 - 0.15e2 / 0.4e1 * t382 - 0.25e2 / 0.8e1 * t386);
  tv2rhotau0 = t5 * t422 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t425 = 0.5e1 / 0.8e1 * t393;
  t427 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t391 + t425);
  tv2rhotau1 = t5 * t427 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t431 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t398 + t418);
  tv2rhotau2 = t5 * t431 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t437 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t403 + t425 - 0.15e2 / 0.4e1 * t408 - 0.25e2 / 0.8e1 * t412);
  tv2rhotau3 = t5 * t437 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t440 = 0.1e1 / t33 / t223;
  t442 = t93 * t217 * t440;
  t443 = t92 * t442;
  t445 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t443);
  tv2lapl20 = t5 * t445;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t447 = 0.1e1 / t59 / t359;
  t449 = t93 * t353 * t447;
  t450 = t147 * t449;
  t452 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t450);
  tv2lapl22 = t5 * t452;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t454 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t443);
  tv2lapltau0 = t5 * t454;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t456 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t450);
  tv2lapltau3 = t5 * t456;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t458 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t443);
  tv2tau20 = t5 * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t460 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t450);
  tv2tau22 = t5 * t460;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t92, t93, t94, t95, t96, t98;
  double t103, t105, t109, t110, t112, t115, t116, t122;
  double t124, tvrho0, t128, t131, t132, t137, t139, t142;
  double t143, t147, t148, t149, t150, t152, t157, t159;
  double t163, tvrho1, tvsigma0, tvsigma1, tvsigma2, t167, t168, t170;
  double tvlapl0, t172, t173, t175, tvlapl1, t177, tvtau0, t179;
  double tvtau1;

  double t182, t183, t184, t187, t188, t189, t192, t196;
  double t197, t202, t204, t208, t211, t212, t213, t214;
  double t217, t218, t220, t223, t225, t230, t232, t236;
  double t237, t238, t239, t242, t245, t249, t250, t255;
  double t259, t261, tv2rho20, t264, t268, t272, t273, t278;
  double t280, t286, t287, t291, t295, t296, t301, t304;
  double t307, t308, t311, tv2rho21, t316, t321, t325, t326;
  double t332, t333, t338, t342, t343, t348, t353, t354;
  double t356, t359, t361, t366, t368, t372, tv2rho22, tv2rhosigma0;
  double tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t375, t377, t378;
  double t379, t381, t382, t385, t386, t389, tv2rholapl0, t391;
  double t393, t394, t396, tv2rholapl1, t398, t401, tv2rholapl2, t403;
  double t405, t407, t408, t411, t412, t415, tv2rholapl3, t418;
  double t422, tv2rhotau0, t425, t427, tv2rhotau1, t431, tv2rhotau2, t437;
  double tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0;
  double tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t440, t442, t443, t445, tv2lapl20;
  double tv2lapl21, t447, t449, t450, t452, tv2lapl22, t454, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t456, tv2lapltau3, t458, tv2tau20, tv2tau21, t460;
  double tv2tau22;

  double t463, t467, t469, t470, t475, t478, t479, t480;
  double t481, t483, t485, t487, t492, t494, t498, t501;
  double t502, t505, t508, t509, t510, t513, t517, t518;
  double t524, t526, t527, t528, t530, t535, t538, t539;
  double t541, t542, t545, t548, t551, t555, t556, t561;
  double t564, t568, t570, tv3rho30, t573, t574, t575, t578;
  double t583, t584, t586, t590, t591, t597, t598, t602;
  double t604, t606, t617, t618, t619, t622, t627, t629;
  double t633, t634, t640, t642, t646, t649, t651, t652;
  double t653, t656, tv3rho31, t659, t664, t668, t672, t673;
  double t678, t680, t687, t688, t693, t697, t701, t702;
  double t707, t710, t713, t714, t720, t724, t726, t727;
  double tv3rho32, t732, t739, t743, t744, t751, t752, t759;
  double t763, t764, t768, t770, t775, t777, t780, t789;
  double t790, t791, t793, t798, t805, t806, tv3rho33, tv3rho2sigma0;
  double tv3rho2sigma1, tv3rho2sigma2, tv3rho2sigma3, tv3rho2sigma4, tv3rho2sigma5, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8;
  double t810, t812, t814, t816, t818, t819, t820, t822;
  double t826, t827, t829, t831, t832, t835, t836, t839;
  double t840, t842, t843, tv3rho2lapl0, t846, t848, t850, t851;
  double t853, tv3rho2lapl1, t855, t857, t859, t861, t867, tv3rho2lapl2;
  double t869, t871, t874, t876, t878, t880, t883, tv3rho2lapl3;
  double t886, t890, tv3rho2lapl4, t893, t896, t898, t904, t905;
  double t907, t909, t910, t913, t914, t917, t918, t920;
  double t921, tv3rho2lapl5, t928, t935, t936, tv3rho2tau0, t941, t943;
  double tv3rho2tau1, t953, tv3rho2tau2, t963, tv3rho2tau3, t969, tv3rho2tau4, t982;
  double t983, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9;
  double tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5;
  double tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t985, t987;
  double t988, t989, t991, t992, t995, t997, t998, t1001;
  double tv3rholapl20, tv3rholapl21, t1003, t1005, t1006, t1008, tv3rholapl22, t1010;
  double t1013, tv3rholapl23, tv3rholapl24, t1015, t1017, t1019, t1020, t1023;
  double t1025, t1026, t1029, tv3rholapl25, t1032, t1036, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, t1039, t1041, tv3rholapltau3, t1045, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double t1051, tv3rholapltau7, t1054, t1058, tv3rhotau20, tv3rhotau21, t1061, t1063;
  double tv3rhotau22, t1067, tv3rhotau23, tv3rhotau24, t1073, tv3rhotau25, tv3sigma30, tv3sigma31;
  double tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t1075, t1076;
  double t1078, t1079, t1081, tv3lapl30, tv3lapl31, tv3lapl32, t1082, t1083;
  double t1085, t1086, t1088, tv3lapl33, t1090, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, t1092, tv3lapl2tau5, t1094, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, t1096, tv3lapltau25, t1098, tv3tau30, tv3tau31, tv3tau32;
  double t1100, tv3tau33;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t90 = 0.5e1 / 0.16e2 * t25 * t87 * t44;
  t91 = t26 * params->prefactor;
  t92 = t25 * t91;
  t93 = t30 * t32;
  t94 = t41 * t41;
  t95 = 0.1e1 / t94;
  t96 = rho[0] * rho[0];
  t98 = 0.1e1 / t34 / t96;
  t103 = -0.1e2 / 0.3e1 * tau[0] * t98 + 0.5e1 / 0.12e2 * lapl[0] * t98;
  t105 = t93 * t95 * t103;
  t109 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t82 * t26 * t44 - t90 + 0.15e2 / 0.16e2 * t92 * t105);
  t110 = t49 * t75;
  t112 = my_piecewise5(t13, 0, t9, 0, -t6 - t110);
  t115 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t112);
  t116 = t4 * t115;
  t122 = 0.5e1 / 0.16e2 * t57 * t87 * t70;
  t124 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t116 * t26 * t70 - t122);
  tvrho0 = t47 + t73 + t5 * (t109 + t124);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t128 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t131 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t128);
  t132 = t4 * t131;
  t137 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t132 * t26 * t44 - t90);
  t139 = my_piecewise5(t13, 0, t9, 0, t6 - t110);
  t142 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t139);
  t143 = t4 * t142;
  t147 = t57 * t91;
  t148 = t67 * t67;
  t149 = 0.1e1 / t148;
  t150 = rho[1] * rho[1];
  t152 = 0.1e1 / t60 / t150;
  t157 = -0.1e2 / 0.3e1 * tau[1] * t152 + 0.5e1 / 0.12e2 * lapl[1] * t152;
  t159 = t93 * t149 * t157;
  t163 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t143 * t26 * t70 - t122 + 0.15e2 / 0.16e2 * t147 * t159);
  tvrho1 = t47 + t73 + t5 * (t137 + t163);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t167 = t93 * t95 * t36;
  t168 = t92 * t167;
  t170 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t168);
  tvlapl0 = t5 * t170;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t172 = t93 * t149 * t62;
  t173 = t147 * t172;
  t175 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t173);
  tvlapl1 = t5 * t175;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t168);
  tvtau0 = t5 * t177;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t179 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t173);
  tvtau1 = t5 * t179;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t182 = t22 * t22;
  t183 = 0.1e1 / t182;
  t184 = t78 * t78;
  t187 = t74 * t5;
  t188 = 0.1e1 / t187;
  t189 = t15 * t188;
  t192 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t189);
  t196 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t184 + 0.4e1 / 0.3e1 * t22 * t192);
  t197 = t4 * t196;
  t202 = t82 * t87 * t44;
  t204 = t82 * t91;
  t208 = 0.1e1 / t86 / t5;
  t211 = 0.5e1 / 0.24e2 * t25 * t208 * t44;
  t212 = t87 * params->prefactor;
  t213 = t25 * t212;
  t214 = t213 * t105;
  t217 = 0.1e1 / t94 / t41;
  t218 = t103 * t103;
  t220 = t93 * t217 * t218;
  t223 = t96 * rho[0];
  t225 = 0.1e1 / t34 / t223;
  t230 = 0.8e2 / 0.9e1 * tau[0] * t225 - 0.1e2 / 0.9e1 * lapl[0] * t225;
  t232 = t93 * t95 * t230;
  t236 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t197 * t26 * t44 - 0.5e1 / 0.8e1 * t202 + 0.15e2 / 0.8e1 * t204 * t105 + t211 + 0.5e1 / 0.8e1 * t214 - 0.15e2 / 0.8e1 * t92 * t220 + 0.15e2 / 0.16e2 * t92 * t232);
  t237 = t54 * t54;
  t238 = 0.1e1 / t237;
  t239 = t112 * t112;
  t242 = t49 * t188;
  t245 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t242);
  t249 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t54 * t245);
  t250 = t4 * t249;
  t255 = t116 * t87 * t70;
  t259 = 0.5e1 / 0.24e2 * t57 * t208 * t70;
  t261 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t250 * t26 * t70 - 0.5e1 / 0.8e1 * t255 + t259);
  tv2rho20 = 0.2e1 * t109 + 0.2e1 * t124 + t5 * (t236 + t261);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t264 = t183 * t128;
  t268 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t189);
  t272 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t264 * t78 + 0.4e1 / 0.3e1 * t22 * t268);
  t273 = t4 * t272;
  t278 = t132 * t87 * t44;
  t280 = t132 * t91;
  t286 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t273 * t26 * t44 - 0.5e1 / 0.16e2 * t278 + 0.15e2 / 0.16e2 * t280 * t105 - 0.5e1 / 0.16e2 * t202 + t211 + 0.5e1 / 0.16e2 * t214);
  t287 = t238 * t139;
  t291 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t242);
  t295 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t287 * t112 + 0.4e1 / 0.3e1 * t54 * t291);
  t296 = t4 * t295;
  t301 = t143 * t87 * t70;
  t304 = t116 * t91;
  t307 = t57 * t212;
  t308 = t307 * t159;
  t311 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t296 * t26 * t70 - 0.5e1 / 0.16e2 * t301 - 0.5e1 / 0.16e2 * t255 + t259 + 0.15e2 / 0.16e2 * t304 * t159 + 0.5e1 / 0.16e2 * t308);
  tv2rho21 = t109 + t124 + t137 + t163 + t5 * (t286 + t311);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t316 = t128 * t128;
  t321 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t189);
  t325 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t316 + 0.4e1 / 0.3e1 * t22 * t321);
  t326 = t4 * t325;
  t332 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t326 * t26 * t44 - 0.5e1 / 0.8e1 * t278 + t211);
  t333 = t139 * t139;
  t338 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t242);
  t342 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t333 + 0.4e1 / 0.3e1 * t54 * t338);
  t343 = t4 * t342;
  t348 = t143 * t91;
  t353 = 0.1e1 / t148 / t67;
  t354 = t157 * t157;
  t356 = t93 * t353 * t354;
  t359 = t150 * rho[1];
  t361 = 0.1e1 / t60 / t359;
  t366 = 0.8e2 / 0.9e1 * tau[1] * t361 - 0.1e2 / 0.9e1 * lapl[1] * t361;
  t368 = t93 * t149 * t366;
  t372 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t343 * t26 * t70 - 0.5e1 / 0.8e1 * t301 + 0.15e2 / 0.8e1 * t348 * t159 + t259 + 0.5e1 / 0.8e1 * t308 - 0.15e2 / 0.8e1 * t147 * t356 + 0.15e2 / 0.16e2 * t147 * t368);
  tv2rho22 = 0.2e1 * t137 + 0.2e1 * t163 + t5 * (t332 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t375 = t204 * t167;
  t377 = t213 * t167;
  t378 = 0.5e1 / 0.64e2 * t377;
  t379 = t217 * t36;
  t381 = t93 * t379 * t103;
  t382 = t92 * t381;
  t385 = t93 * t95 * t98;
  t386 = t92 * t385;
  t389 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t375 - t378 + 0.15e2 / 0.32e2 * t382 + 0.25e2 / 0.64e2 * t386);
  tv2rholapl0 = t5 * t389 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t391 = t304 * t172;
  t393 = t307 * t172;
  t394 = 0.5e1 / 0.64e2 * t393;
  t396 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t391 - t394);
  tv2rholapl1 = t5 * t396 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t398 = t280 * t167;
  t401 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t398 - t378);
  tv2rholapl2 = t5 * t401 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t403 = t348 * t172;
  t405 = t353 * t62;
  t407 = t93 * t405 * t157;
  t408 = t147 * t407;
  t411 = t93 * t149 * t152;
  t412 = t147 * t411;
  t415 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t403 - t394 + 0.15e2 / 0.32e2 * t408 + 0.25e2 / 0.64e2 * t412);
  tv2rholapl3 = t5 * t415 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t418 = 0.5e1 / 0.8e1 * t377;
  t422 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t375 + t418 - 0.15e2 / 0.4e1 * t382 - 0.25e2 / 0.8e1 * t386);
  tv2rhotau0 = t5 * t422 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t425 = 0.5e1 / 0.8e1 * t393;
  t427 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t391 + t425);
  tv2rhotau1 = t5 * t427 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t431 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t398 + t418);
  tv2rhotau2 = t5 * t431 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t437 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t403 + t425 - 0.15e2 / 0.4e1 * t408 - 0.25e2 / 0.8e1 * t412);
  tv2rhotau3 = t5 * t437 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t440 = 0.1e1 / t33 / t223;
  t442 = t93 * t217 * t440;
  t443 = t92 * t442;
  t445 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t443);
  tv2lapl20 = t5 * t445;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t447 = 0.1e1 / t59 / t359;
  t449 = t93 * t353 * t447;
  t450 = t147 * t449;
  t452 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t450);
  tv2lapl22 = t5 * t452;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t454 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t443);
  tv2lapltau0 = t5 * t454;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t456 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t450);
  tv2lapltau3 = t5 * t456;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t458 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t443);
  tv2tau20 = t5 * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t460 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t450);
  tv2tau22 = t5 * t460;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t463 = t197 * t91;
  t467 = t82 * t208 * t44;
  t469 = t82 * t212;
  t470 = t469 * t105;
  t475 = 0.1e1 / t86 / t74;
  t478 = 0.25e2 / 0.72e2 * t25 * t475 * t44;
  t479 = t208 * params->prefactor;
  t480 = t25 * t479;
  t481 = t480 * t105;
  t483 = t213 * t232;
  t485 = t96 * t96;
  t487 = 0.1e1 / t34 / t485;
  t492 = -0.88e3 / 0.27e2 * tau[0] * t487 + 0.11e3 / 0.27e2 * lapl[0] * t487;
  t494 = t93 * t95 * t492;
  t498 = t197 * t87 * t44;
  t501 = 0.1e1 / t182 / t18;
  t502 = t184 * t78;
  t505 = t183 * t78;
  t508 = t74 * t74;
  t509 = 0.1e1 / t508;
  t510 = t15 * t509;
  t513 = my_piecewise5(t9, 0, t13, 0, 0.6e1 * t188 - 0.6e1 * t510);
  t517 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t501 * t502 + 0.4e1 / 0.3e1 * t505 * t192 + 0.4e1 / 0.3e1 * t22 * t513);
  t518 = t4 * t517;
  t524 = t213 * t220;
  t526 = t94 * t94;
  t527 = 0.1e1 / t526;
  t528 = t218 * t103;
  t530 = t93 * t527 * t528;
  t535 = t93 * t217 * t103 * t230;
  t538 = 0.45e2 / 0.16e2 * t463 * t105 + 0.5e1 / 0.8e1 * t467 + 0.15e2 / 0.8e1 * t470 + 0.45e2 / 0.16e2 * t204 * t232 - t478 - 0.5e1 / 0.8e1 * t481 + 0.15e2 / 0.16e2 * t483 + 0.15e2 / 0.16e2 * t92 * t494 - 0.15e2 / 0.16e2 * t498 - 0.15e2 / 0.16e2 * t518 * t26 * t44 - 0.45e2 / 0.8e1 * t204 * t220 - 0.15e2 / 0.8e1 * t524 + 0.45e2 / 0.8e1 * t92 * t530 - 0.45e2 / 0.8e1 * t92 * t535;
  t539 = my_piecewise3(t2, 0, t538);
  t541 = 0.1e1 / t237 / t52;
  t542 = t239 * t112;
  t545 = t238 * t112;
  t548 = t49 * t509;
  t551 = my_piecewise5(t13, 0, t9, 0, -0.6e1 * t188 - 0.6e1 * t548);
  t555 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t542 + 0.4e1 / 0.3e1 * t545 * t245 + 0.4e1 / 0.3e1 * t54 * t551);
  t556 = t4 * t555;
  t561 = t250 * t87 * t70;
  t564 = t116 * t208 * t70;
  t568 = 0.25e2 / 0.72e2 * t57 * t475 * t70;
  t570 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t556 * t26 * t70 - 0.15e2 / 0.16e2 * t561 + 0.5e1 / 0.8e1 * t564 - t568);
  tv3rho30 = 0.3e1 * t236 + 0.3e1 * t261 + t5 * (t539 + t570);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t573 = 0.2e1 * t286;
  t574 = 0.2e1 * t311;
  t575 = t501 * t128;
  t578 = t183 * t268;
  t583 = 0.2e1 * t188;
  t584 = 0.6e1 * t510;
  t586 = my_piecewise5(t9, 0, t13, 0, t583 - t584);
  t590 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t575 * t184 + 0.8e1 / 0.9e1 * t578 * t78 + 0.4e1 / 0.9e1 * t264 * t192 + 0.4e1 / 0.3e1 * t22 * t586);
  t591 = t4 * t590;
  t597 = 0.5e1 / 0.8e1 * t273 * t87 * t44;
  t598 = t273 * t91;
  t602 = t132 * t208 * t44;
  t604 = t132 * t212;
  t606 = 0.5e1 / 0.8e1 * t604 * t105;
  t617 = -0.15e2 / 0.16e2 * t591 * t26 * t44 - t597 + 0.15e2 / 0.8e1 * t598 * t105 + 0.5e1 / 0.24e2 * t602 + t606 - 0.15e2 / 0.8e1 * t280 * t220 + 0.15e2 / 0.16e2 * t280 * t232 - 0.5e1 / 0.16e2 * t498 + 0.5e1 / 0.12e2 * t467 + 0.5e1 / 0.8e1 * t470 - t478 - 0.5e1 / 0.12e2 * t481 - 0.5e1 / 0.8e1 * t524 + 0.5e1 / 0.16e2 * t483;
  t618 = my_piecewise3(t2, 0, t617);
  t619 = t541 * t139;
  t622 = t238 * t291;
  t627 = 0.6e1 * t548;
  t629 = my_piecewise5(t13, 0, t9, 0, -t583 - t627);
  t633 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t619 * t239 + 0.8e1 / 0.9e1 * t622 * t112 + 0.4e1 / 0.9e1 * t287 * t245 + 0.4e1 / 0.3e1 * t54 * t629);
  t634 = t4 * t633;
  t640 = 0.5e1 / 0.8e1 * t296 * t87 * t70;
  t642 = t143 * t208 * t70;
  t646 = t250 * t91;
  t649 = t116 * t212;
  t651 = 0.5e1 / 0.8e1 * t649 * t159;
  t652 = t57 * t479;
  t653 = t652 * t159;
  t656 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t634 * t26 * t70 - t640 + 0.5e1 / 0.24e2 * t642 - 0.5e1 / 0.16e2 * t561 + 0.5e1 / 0.12e2 * t564 - t568 + 0.15e2 / 0.16e2 * t646 * t159 + t651 - 0.5e1 / 0.24e2 * t653);
  tv3rho31 = t236 + t261 + t573 + t574 + t5 * (t618 + t656);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t659 = t501 * t316;
  t664 = t183 * t321;
  t668 = my_piecewise5(t9, 0, t13, 0, -t583 - t584);
  t672 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t659 * t78 + 0.8e1 / 0.9e1 * t264 * t268 + 0.4e1 / 0.9e1 * t664 * t78 + 0.4e1 / 0.3e1 * t22 * t668);
  t673 = t4 * t672;
  t678 = t326 * t87 * t44;
  t680 = t326 * t91;
  t687 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t673 * t26 * t44 - 0.5e1 / 0.16e2 * t678 + 0.15e2 / 0.16e2 * t680 * t105 - t597 + 0.5e1 / 0.12e2 * t602 + t606 + 0.5e1 / 0.24e2 * t467 - t478 - 0.5e1 / 0.24e2 * t481);
  t688 = t541 * t333;
  t693 = t238 * t338;
  t697 = my_piecewise5(t13, 0, t9, 0, t583 - t627);
  t701 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t688 * t112 + 0.8e1 / 0.9e1 * t287 * t291 + 0.4e1 / 0.9e1 * t693 * t112 + 0.4e1 / 0.3e1 * t54 * t697);
  t702 = t4 * t701;
  t707 = t343 * t87 * t70;
  t710 = t296 * t91;
  t713 = t143 * t212;
  t714 = t713 * t159;
  t720 = t307 * t356;
  t724 = t307 * t368;
  t726 = -0.15e2 / 0.16e2 * t702 * t26 * t70 - 0.5e1 / 0.16e2 * t707 - t640 + 0.5e1 / 0.12e2 * t642 + 0.15e2 / 0.8e1 * t710 * t159 + 0.5e1 / 0.8e1 * t714 + 0.5e1 / 0.24e2 * t564 - t568 + t651 - 0.5e1 / 0.12e2 * t653 - 0.15e2 / 0.8e1 * t304 * t356 - 0.5e1 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t304 * t368 + 0.5e1 / 0.16e2 * t724;
  t727 = my_piecewise3(t48, 0, t726);
  tv3rho32 = t573 + t574 + t332 + t372 + t5 * (t687 + t727);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t732 = t316 * t128;
  t739 = my_piecewise5(t9, 0, t13, 0, -0.6e1 * t188 - 0.6e1 * t510);
  t743 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t501 * t732 + 0.4e1 / 0.3e1 * t264 * t321 + 0.4e1 / 0.3e1 * t22 * t739);
  t744 = t4 * t743;
  t751 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t744 * t26 * t44 - 0.15e2 / 0.16e2 * t678 + 0.5e1 / 0.8e1 * t602 - t478);
  t752 = t333 * t139;
  t759 = my_piecewise5(t13, 0, t9, 0, 0.6e1 * t188 - 0.6e1 * t548);
  t763 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t752 + 0.4e1 / 0.3e1 * t287 * t338 + 0.4e1 / 0.3e1 * t54 * t759);
  t764 = t4 * t763;
  t768 = t150 * t150;
  t770 = 0.1e1 / t60 / t768;
  t775 = -0.88e3 / 0.27e2 * tau[1] * t770 + 0.11e3 / 0.27e2 * lapl[1] * t770;
  t777 = t93 * t149 * t775;
  t780 = t343 * t91;
  t789 = t148 * t148;
  t790 = 0.1e1 / t789;
  t791 = t354 * t157;
  t793 = t93 * t790 * t791;
  t798 = t93 * t353 * t157 * t366;
  t805 = -0.15e2 / 0.16e2 * t764 * t26 * t70 + 0.15e2 / 0.16e2 * t147 * t777 + 0.45e2 / 0.16e2 * t780 * t159 + 0.45e2 / 0.16e2 * t348 * t368 - 0.15e2 / 0.16e2 * t707 + 0.5e1 / 0.8e1 * t642 - t568 - 0.45e2 / 0.8e1 * t348 * t356 + 0.45e2 / 0.8e1 * t147 * t793 - 0.45e2 / 0.8e1 * t147 * t798 + 0.15e2 / 0.8e1 * t714 - 0.15e2 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t724 - 0.5e1 / 0.8e1 * t653;
  t806 = my_piecewise3(t48, 0, t805);
  tv3rho33 = 0.3e1 * t332 + 0.3e1 * t372 + t5 * (t751 + t806);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  tv3rho2sigma0 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  tv3rho2sigma3 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  tv3rho2sigma6 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t810 = t463 * t167;
  t812 = t469 * t167;
  t814 = t204 * t381;
  t816 = t204 * t385;
  t818 = t480 * t167;
  t819 = 0.5e1 / 0.96e2 * t818;
  t820 = t213 * t381;
  t822 = t213 * t385;
  t826 = t93 * t527 * t36 * t218;
  t827 = t92 * t826;
  t829 = t217 * t98;
  t831 = t93 * t829 * t103;
  t832 = t92 * t831;
  t835 = t93 * t379 * t230;
  t836 = t92 * t835;
  t839 = t93 * t95 * t225;
  t840 = t92 * t839;
  t842 = -0.15e2 / 0.64e2 * t810 - 0.5e1 / 0.32e2 * t812 + 0.15e2 / 0.16e2 * t814 + 0.25e2 / 0.32e2 * t816 + t819 + 0.5e1 / 0.16e2 * t820 + 0.25e2 / 0.96e2 * t822 - 0.45e2 / 0.32e2 * t827 - 0.25e2 / 0.16e2 * t832 + 0.15e2 / 0.32e2 * t836 - 0.25e2 / 0.24e2 * t840;
  t843 = my_piecewise3(t2, 0, t842);
  tv3rho2lapl0 = t5 * t843 + 0.2e1 * t389;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t846 = t646 * t172;
  t848 = t649 * t172;
  t850 = t652 * t172;
  t851 = 0.5e1 / 0.96e2 * t850;
  t853 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t846 - 0.5e1 / 0.32e2 * t848 + t851);
  tv3rho2lapl1 = t5 * t853 + 0.2e1 * t396;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t855 = t598 * t167;
  t857 = t604 * t167;
  t859 = t280 * t381;
  t861 = t280 * t385;
  t867 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t855 - 0.5e1 / 0.64e2 * t857 + 0.15e2 / 0.32e2 * t859 + 0.25e2 / 0.64e2 * t861 - 0.5e1 / 0.64e2 * t812 + t819 + 0.5e1 / 0.32e2 * t820 + 0.25e2 / 0.192e3 * t822);
  tv3rho2lapl2 = t5 * t867 + t389 + t401;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t869 = t710 * t172;
  t871 = t713 * t172;
  t874 = t304 * t407;
  t876 = t307 * t407;
  t878 = t304 * t411;
  t880 = t307 * t411;
  t883 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t869 - 0.5e1 / 0.64e2 * t871 - 0.5e1 / 0.64e2 * t848 + t851 + 0.15e2 / 0.32e2 * t874 + 0.5e1 / 0.32e2 * t876 + 0.25e2 / 0.64e2 * t878 + 0.25e2 / 0.192e3 * t880);
  tv3rho2lapl3 = t5 * t883 + t396 + t415;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t886 = t680 * t167;
  t890 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t886 - 0.5e1 / 0.32e2 * t857 + t819);
  tv3rho2lapl4 = t5 * t890 + 0.2e1 * t401;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t893 = t780 * t172;
  t896 = t348 * t407;
  t898 = t348 * t411;
  t904 = t93 * t790 * t62 * t354;
  t905 = t147 * t904;
  t907 = t353 * t152;
  t909 = t93 * t907 * t157;
  t910 = t147 * t909;
  t913 = t93 * t405 * t366;
  t914 = t147 * t913;
  t917 = t93 * t149 * t361;
  t918 = t147 * t917;
  t920 = -0.15e2 / 0.64e2 * t893 - 0.5e1 / 0.32e2 * t871 + 0.15e2 / 0.16e2 * t896 + 0.25e2 / 0.32e2 * t898 + t851 + 0.5e1 / 0.16e2 * t876 + 0.25e2 / 0.96e2 * t880 - 0.45e2 / 0.32e2 * t905 - 0.25e2 / 0.16e2 * t910 + 0.15e2 / 0.32e2 * t914 - 0.25e2 / 0.24e2 * t918;
  t921 = my_piecewise3(t48, 0, t920);
  tv3rho2lapl5 = t5 * t921 + 0.2e1 * t415;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t928 = 0.5e1 / 0.12e2 * t818;
  t935 = 0.15e2 / 0.8e1 * t810 + 0.5e1 / 0.4e1 * t812 - 0.15e2 / 0.2e1 * t814 - 0.25e2 / 0.4e1 * t816 - t928 - 0.5e1 / 0.2e1 * t820 - 0.25e2 / 0.12e2 * t822 + 0.45e2 / 0.4e1 * t827 + 0.25e2 / 0.2e1 * t832 - 0.15e2 / 0.4e1 * t836 + 0.25e2 / 0.3e1 * t840;
  t936 = my_piecewise3(t2, 0, t935);
  tv3rho2tau0 = t5 * t936 + 0.2e1 * t422;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t941 = 0.5e1 / 0.12e2 * t850;
  t943 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t846 + 0.5e1 / 0.4e1 * t848 - t941);
  tv3rho2tau1 = t5 * t943 + 0.2e1 * t427;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t953 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t855 + 0.5e1 / 0.8e1 * t857 - 0.15e2 / 0.4e1 * t859 - 0.25e2 / 0.8e1 * t861 + 0.5e1 / 0.8e1 * t812 - t928 - 0.5e1 / 0.4e1 * t820 - 0.25e2 / 0.24e2 * t822);
  tv3rho2tau2 = t5 * t953 + t422 + t431;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t963 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t869 + 0.5e1 / 0.8e1 * t871 + 0.5e1 / 0.8e1 * t848 - t941 - 0.15e2 / 0.4e1 * t874 - 0.5e1 / 0.4e1 * t876 - 0.25e2 / 0.8e1 * t878 - 0.25e2 / 0.24e2 * t880);
  tv3rho2tau3 = t5 * t963 + t427 + t437;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t969 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t886 + 0.5e1 / 0.4e1 * t857 - t928);
  tv3rho2tau4 = t5 * t969 + 0.2e1 * t431;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t982 = 0.15e2 / 0.8e1 * t893 + 0.5e1 / 0.4e1 * t871 - 0.15e2 / 0.2e1 * t896 - 0.25e2 / 0.4e1 * t898 - t941 - 0.5e1 / 0.2e1 * t876 - 0.25e2 / 0.12e2 * t880 + 0.45e2 / 0.4e1 * t905 + 0.25e2 / 0.2e1 * t910 - 0.15e2 / 0.4e1 * t914 + 0.25e2 / 0.3e1 * t918;
  t983 = my_piecewise3(t48, 0, t982);
  tv3rho2tau5 = t5 * t983 + 0.2e1 * t437;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t985 = t204 * t442;
  t987 = t213 * t442;
  t988 = 0.5e1 / 0.128e3 * t987;
  t989 = t527 * t440;
  t991 = t93 * t989 * t103;
  t992 = t92 * t991;
  t995 = 0.1e1 / t33 / t485;
  t997 = t93 * t217 * t995;
  t998 = t92 * t997;
  t1001 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t985 - t988 + 0.45e2 / 0.128e3 * t992 + 0.25e2 / 0.64e2 * t998);
  tv3rholapl20 = t5 * t1001 + t445;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t1003 = t304 * t449;
  t1005 = t307 * t449;
  t1006 = 0.5e1 / 0.128e3 * t1005;
  t1008 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1003 - t1006);
  tv3rholapl22 = t5 * t1008 + t452;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t1010 = t280 * t442;
  t1013 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t1010 - t988);
  tv3rholapl23 = t5 * t1013 + t445;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t1015 = t348 * t449;
  t1017 = t790 * t447;
  t1019 = t93 * t1017 * t157;
  t1020 = t147 * t1019;
  t1023 = 0.1e1 / t59 / t768;
  t1025 = t93 * t353 * t1023;
  t1026 = t147 * t1025;
  t1029 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1015 - t1006 + 0.45e2 / 0.128e3 * t1020 + 0.25e2 / 0.64e2 * t1026);
  tv3rholapl25 = t5 * t1029 + t452;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t1032 = 0.5e1 / 0.16e2 * t987;
  t1036 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t985 + t1032 - 0.45e2 / 0.16e2 * t992 - 0.25e2 / 0.8e1 * t998);
  tv3rholapltau0 = t5 * t1036 + t454;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t1039 = 0.5e1 / 0.16e2 * t1005;
  t1041 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1003 + t1039);
  tv3rholapltau3 = t5 * t1041 + t456;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t1045 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t1010 + t1032);
  tv3rholapltau4 = t5 * t1045 + t454;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t1051 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1015 + t1039 - 0.45e2 / 0.16e2 * t1020 - 0.25e2 / 0.8e1 * t1026);
  tv3rholapltau7 = t5 * t1051 + t456;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t1054 = 0.5e1 / 0.2e1 * t987;
  t1058 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t985 - t1054 + 0.45e2 / 0.2e1 * t992 + 0.25e2 * t998);
  tv3rhotau20 = t5 * t1058 + t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t1061 = 0.5e1 / 0.2e1 * t1005;
  t1063 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1003 - t1061);
  tv3rhotau22 = t5 * t1063 + t460;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t1067 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t1010 - t1054);
  tv3rhotau23 = t5 * t1067 + t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t1073 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1015 - t1061 + 0.45e2 / 0.2e1 * t1020 + 0.25e2 * t1026);
  tv3rhotau25 = t5 * t1073 + t460;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t1075 = t485 * rho[0];
  t1076 = 0.1e1 / t1075;
  t1078 = t93 * t527 * t1076;
  t1079 = t92 * t1078;
  t1081 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t1079);
  tv3lapl30 = t5 * t1081;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t1082 = t768 * rho[1];
  t1083 = 0.1e1 / t1082;
  t1085 = t93 * t790 * t1083;
  t1086 = t147 * t1085;
  t1088 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t1086);
  tv3lapl33 = t5 * t1088;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t1090 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t1079);
  tv3lapl2tau0 = t5 * t1090;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t1092 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t1086);
  tv3lapl2tau5 = t5 * t1092;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t1094 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t1079);
  tv3lapltau20 = t5 * t1094;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t1096 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t1086);
  tv3lapltau25 = t5 * t1096;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t1098 = my_piecewise3(t2, 0, 0.45e2 * t1079);
  tv3tau30 = t5 * t1098;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t1100 = my_piecewise3(t48, 0, 0.45e2 * t1086);
  tv3tau33 = t5 * t1100;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73, tzk0;

  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t92, t93, t94, t95, t96, t98;
  double t103, t105, t109, t110, t112, t115, t116, t122;
  double t124, tvrho0, t128, t131, t132, t137, t139, t142;
  double t143, t147, t148, t149, t150, t152, t157, t159;
  double t163, tvrho1, tvsigma0, tvsigma1, tvsigma2, t167, t168, t170;
  double tvlapl0, t172, t173, t175, tvlapl1, t177, tvtau0, t179;
  double tvtau1;

  double t182, t183, t184, t187, t188, t189, t192, t196;
  double t197, t202, t204, t208, t211, t212, t213, t214;
  double t217, t218, t220, t223, t225, t230, t232, t236;
  double t237, t238, t239, t242, t245, t249, t250, t255;
  double t259, t261, tv2rho20, t264, t268, t272, t273, t278;
  double t280, t286, t287, t291, t295, t296, t301, t304;
  double t307, t308, t311, tv2rho21, t316, t321, t325, t326;
  double t332, t333, t338, t342, t343, t348, t353, t354;
  double t356, t359, t361, t366, t368, t372, tv2rho22, tv2rhosigma0;
  double tv2rhosigma1, tv2rhosigma2, tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t375, t377, t378;
  double t379, t381, t382, t385, t386, t389, tv2rholapl0, t391;
  double t393, t394, t396, tv2rholapl1, t398, t401, tv2rholapl2, t403;
  double t405, t407, t408, t411, t412, t415, tv2rholapl3, t418;
  double t422, tv2rhotau0, t425, t427, tv2rhotau1, t431, tv2rhotau2, t437;
  double tv2rhotau3, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0;
  double tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2;
  double tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t440, t442, t443, t445, tv2lapl20;
  double tv2lapl21, t447, t449, t450, t452, tv2lapl22, t454, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t456, tv2lapltau3, t458, tv2tau20, tv2tau21, t460;
  double tv2tau22;

  double t463, t467, t469, t470, t475, t478, t479, t480;
  double t481, t483, t485, t487, t492, t494, t498, t501;
  double t502, t505, t508, t509, t510, t513, t517, t518;
  double t524, t526, t527, t528, t530, t535, t538, t539;
  double t541, t542, t545, t548, t551, t555, t556, t561;
  double t564, t568, t570, tv3rho30, t573, t574, t575, t578;
  double t583, t584, t586, t590, t591, t597, t598, t602;
  double t604, t606, t617, t618, t619, t622, t627, t629;
  double t633, t634, t640, t642, t646, t649, t651, t652;
  double t653, t656, tv3rho31, t659, t664, t668, t672, t673;
  double t678, t680, t687, t688, t693, t697, t701, t702;
  double t707, t710, t713, t714, t720, t724, t726, t727;
  double tv3rho32, t732, t739, t743, t744, t751, t752, t759;
  double t763, t764, t768, t770, t775, t777, t780, t789;
  double t790, t791, t793, t798, t805, t806, tv3rho33, tv3rho2sigma0;
  double tv3rho2sigma1, tv3rho2sigma2, tv3rho2sigma3, tv3rho2sigma4, tv3rho2sigma5, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8;
  double t810, t812, t814, t816, t818, t819, t820, t822;
  double t826, t827, t829, t831, t832, t835, t836, t839;
  double t840, t842, t843, tv3rho2lapl0, t846, t848, t850, t851;
  double t853, tv3rho2lapl1, t855, t857, t859, t861, t867, tv3rho2lapl2;
  double t869, t871, t874, t876, t878, t880, t883, tv3rho2lapl3;
  double t886, t890, tv3rho2lapl4, t893, t896, t898, t904, t905;
  double t907, t909, t910, t913, t914, t917, t918, t920;
  double t921, tv3rho2lapl5, t928, t935, t936, tv3rho2tau0, t941, t943;
  double tv3rho2tau1, t953, tv3rho2tau2, t963, tv3rho2tau3, t969, tv3rho2tau4, t982;
  double t983, tv3rho2tau5, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25;
  double tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1;
  double tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9;
  double tv3rhosigmalapl10, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5;
  double tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t985, t987;
  double t988, t989, t991, t992, t995, t997, t998, t1001;
  double tv3rholapl20, tv3rholapl21, t1003, t1005, t1006, t1008, tv3rholapl22, t1010;
  double t1013, tv3rholapl23, tv3rholapl24, t1015, t1017, t1019, t1020, t1023;
  double t1025, t1026, t1029, tv3rholapl25, t1032, t1036, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, t1039, t1041, tv3rholapltau3, t1045, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double t1051, tv3rholapltau7, t1054, t1058, tv3rhotau20, tv3rhotau21, t1061, t1063;
  double tv3rhotau22, t1067, tv3rhotau23, tv3rhotau24, t1073, tv3rhotau25, tv3sigma30, tv3sigma31;
  double tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11;
  double tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27;
  double tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6;
  double tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22;
  double tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, t1075, t1076;
  double t1078, t1079, t1081, tv3lapl30, tv3lapl31, tv3lapl32, t1082, t1083;
  double t1085, t1086, t1088, tv3lapl33, t1090, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, t1092, tv3lapl2tau5, t1094, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, t1096, tv3lapltau25, t1098, tv3tau30, tv3tau31, tv3tau32;
  double t1100, tv3tau33;

  double t1104, t1107, t1109, t1111, t1112, t1118, t1124, t1125;
  double t1128, t1132, t1138, t1141, t1144, t1152, t1160, t1171;
  double t1172, t1177, t1184, t1185, t1187, t1188, t1192, t1194;
  double t1198, t1199, t1201, t1205, t1206, t1207, t1209, t1211;
  double t1213, t1216, t1218, t1219, t1221, t1222, t1228, t1233;
  double t1236, t1240, t1246, t1249, t1252, t1256, t1258, tv4rho40;
  double t1267, t1270, t1271, t1273, t1291, t1292, t1294, t1298;
  double t1310, t1318, t1321, t1322, t1326, t1327, t1328, t1329;
  double t1331, t1337, t1339, t1356, t1358, t1362, t1368, t1371;
  double t1372, t1374, t1379, t1382, t1383, t1385, t1386, t1387;
  double t1388, t1389, t1391, t1392, tv4rho41, t1400, t1402, t1406;
  double t1408, t1409, t1432, t1445, t1449, t1459, t1461, t1462;
  double t1470, t1473, t1481, t1482, t1484, t1486, t1488, t1490;
  double t1493, t1494, t1506, t1519, t1523, t1528, t1530, tv4rho42;
  double t1551, t1555, t1561, t1563, t1572, t1573, t1575, t1593;
  double t1597, t1606, t1613, t1620, t1629, t1631, t1633, t1634;
  double t1636, t1638, t1640, t1642, tv4rho43, t1647, t1652, t1659;
  double t1663, t1672, t1674, t1679, t1686, t1690, t1714, t1720;
  double t1730, t1731, t1736, t1742, t1754, t1756, tv4rho44, tv4rho3sigma0;
  double tv4rho3sigma1, tv4rho3sigma2, tv4rho3sigma3, tv4rho3sigma4, tv4rho3sigma5, tv4rho3sigma6, tv4rho3sigma7, tv4rho3sigma8;
  double tv4rho3sigma9, tv4rho3sigma10, tv4rho3sigma11, t1760, t1766, t1768, t1772, t1776;
  double t1778, t1780, t1782, t1784, t1786, t1791, t1796, t1801;
  double t1803, t1804, t1806, t1808, t1812, t1814, t1816, t1818;
  double t1820, t1822, t1824, t1826, t1828, t1829, t1830, t1832;
  double t1834, tv4rho3lapl0, t1837, t1839, t1841, t1843, t1844, t1846;
  double tv4rho3lapl1, t1848, t1849, t1850, t1851, t1853, t1855, t1857;
  double t1858, t1859, t1860, t1861, t1863, t1868, t1874, t1876;
  double t1878, t1882, t1884, tv4rho3lapl2, t1886, t1887, t1889, t1890;
  double t1891, t1895, t1897, t1898, t1899, t1901, t1903, t1904;
  double t1905, t1907, t1908, tv4rho3lapl3, t1910, t1912, t1914, t1916;
  double t1922, t1923, tv4rho3lapl4, t1925, t1927, t1930, t1932, t1934;
  double t1936, t1939, t1942, t1944, t1946, t1948, t1950, t1952;
  double t1954, t1956, t1958, t1960, tv4rho3lapl5, t1963, t1968, tv4rho3lapl6;
  double t1976, t1981, t1986, t1991, t1993, t1995, t2002, t2006;
  double t2008, t2010, t2011, t2022, t2024, t2026, t2028, t2030;
  double t2032, tv4rho3lapl7, t2047, t2059, t2061, t2063, tv4rho3tau0, t2069;
  double t2071, tv4rho3tau1, t2073, t2074, t2078, t2079, t2085, t2096;
  double t2098, tv4rho3tau2, t2100, t2102, t2107, t2110, t2112, t2113;
  double tv4rho3tau3, t2123, t2124, tv4rho3tau4, t2134, t2145, t2147, tv4rho3tau5;
  double t2154, tv4rho3tau6, t2169, t2182, t2184, tv4rho3tau7, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, tv4rho2sigma211, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217;
  double tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15;
  double tv4rho2sigmalapl16, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13;
  double tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t2187, t2189, t2191, t2193;
  double t2195, t2196, t2197, t2199, t2204, t2209, t2213, t2219;
  double t2221, t2222, tv4rho2lapl20, tv4rho2lapl21, t2225, t2227, t2229, t2230;
  double t2232, tv4rho2lapl22, t2234, t2236, t2238, t2240, t2246, tv4rho2lapl23;
  double tv4rho2lapl24, t2248, t2250, t2253, t2255, t2257, t2259, t2262;
  double tv4rho2lapl25, t2265, t2269, tv4rho2lapl26, tv4rho2lapl27, t2272, t2275, t2277;
  double t2284, t2289, t2293, t2299, t2301, t2302, tv4rho2lapl28, t2309;
  double t2316, t2317, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, t2322, t2324, tv4rho2lapltau3;
  double t2334, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, t2344, tv4rho2lapltau7, t2350, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, t2363, t2364, tv4rho2lapltau11, t2371, t2378, t2379;
  double tv4rho2tau20, tv4rho2tau21, t2384, t2386, tv4rho2tau22, t2396, tv4rho2tau23, tv4rho2tau24;
  double t2406, tv4rho2tau25, t2412, tv4rho2tau26, tv4rho2tau27, t2425, t2426, tv4rho2tau28;
  double tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, tv4rhosigma39, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3;
  double tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11;
  double tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19;
  double tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3;
  double tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11;
  double tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19;
  double tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23;
  double tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211;
  double tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1;
  double tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9;
  double tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17;
  double tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21;
  double tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29;
  double tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217;
  double t2428, t2430, t2431, t2435, t2437, t2441, t2444, tv4rholapl30;
  double tv4rholapl31, tv4rholapl32, t2446, t2448, t2449, t2451, tv4rholapl33, t2453;
  double t2456, tv4rholapl34, tv4rholapl35, tv4rholapl36, t2458, t2463, t2465, t2469;
  double t2472, tv4rholapl37, t2475, t2479, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3;
  double tv4rholapl2tau4, t2482, t2484, tv4rholapl2tau5, t2488, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8;
  double tv4rholapl2tau9, tv4rholapl2tau10, t2494, tv4rholapl2tau11, t2497, t2501, tv4rholapltau20, tv4rholapltau21;
  double tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, t2504, t2506, tv4rholapltau25, t2510, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, t2516, tv4rholapltau211, t2519, t2523;
  double tv4rhotau30, tv4rhotau31, tv4rhotau32, t2526, t2528, tv4rhotau33, t2532, tv4rhotau34;
  double tv4rhotau35, tv4rhotau36, t2538, tv4rhotau37, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43;
  double tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, tv4sigma3tau0;
  double tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8;
  double tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16;
  double tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24;
  double tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212;
  double tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2;
  double tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10;
  double tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18;
  double tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22;
  double tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210;
  double tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30;
  double tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38;
  double tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4;
  double tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12;
  double tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22;
  double tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210;
  double tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30;
  double tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38;
  double tv4sigmatau39, tv4sigmatau310, tv4sigmatau311, t2544, t2546, tv4lapl40, tv4lapl41, tv4lapl42;
  double tv4lapl43, t2551, t2553, tv4lapl44, t2555, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2;
  double tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, t2557, tv4lapl3tau7, t2559, tv4lapl2tau20;
  double tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, t2561;
  double tv4lapl2tau28, t2563, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35;
  double tv4lapltau36, t2565, tv4lapltau37, t2567, tv4tau40, tv4tau41, tv4tau42, tv4tau43;
  double t2569, tv4tau44;

  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  tzk0 = t47 + t73;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t90 = 0.5e1 / 0.16e2 * t25 * t87 * t44;
  t91 = t26 * params->prefactor;
  t92 = t25 * t91;
  t93 = t30 * t32;
  t94 = t41 * t41;
  t95 = 0.1e1 / t94;
  t96 = rho[0] * rho[0];
  t98 = 0.1e1 / t34 / t96;
  t103 = -0.1e2 / 0.3e1 * tau[0] * t98 + 0.5e1 / 0.12e2 * lapl[0] * t98;
  t105 = t93 * t95 * t103;
  t109 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t82 * t26 * t44 - t90 + 0.15e2 / 0.16e2 * t92 * t105);
  t110 = t49 * t75;
  t112 = my_piecewise5(t13, 0, t9, 0, -t6 - t110);
  t115 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t112);
  t116 = t4 * t115;
  t122 = 0.5e1 / 0.16e2 * t57 * t87 * t70;
  t124 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t116 * t26 * t70 - t122);
  tvrho0 = t47 + t73 + t5 * (t109 + t124);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t128 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t131 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t128);
  t132 = t4 * t131;
  t137 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t132 * t26 * t44 - t90);
  t139 = my_piecewise5(t13, 0, t9, 0, t6 - t110);
  t142 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t139);
  t143 = t4 * t142;
  t147 = t57 * t91;
  t148 = t67 * t67;
  t149 = 0.1e1 / t148;
  t150 = rho[1] * rho[1];
  t152 = 0.1e1 / t60 / t150;
  t157 = -0.1e2 / 0.3e1 * tau[1] * t152 + 0.5e1 / 0.12e2 * lapl[1] * t152;
  t159 = t93 * t149 * t157;
  t163 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t143 * t26 * t70 - t122 + 0.15e2 / 0.16e2 * t147 * t159);
  tvrho1 = t47 + t73 + t5 * (t137 + t163);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  tvsigma0 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t167 = t93 * t95 * t36;
  t168 = t92 * t167;
  t170 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t168);
  tvlapl0 = t5 * t170;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t172 = t93 * t149 * t62;
  t173 = t147 * t172;
  t175 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t173);
  tvlapl1 = t5 * t175;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t177 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t168);
  tvtau0 = t5 * t177;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t179 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t173);
  tvtau1 = t5 * t179;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t182 = t22 * t22;
  t183 = 0.1e1 / t182;
  t184 = t78 * t78;
  t187 = t74 * t5;
  t188 = 0.1e1 / t187;
  t189 = t15 * t188;
  t192 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t189);
  t196 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t184 + 0.4e1 / 0.3e1 * t22 * t192);
  t197 = t4 * t196;
  t202 = t82 * t87 * t44;
  t204 = t82 * t91;
  t208 = 0.1e1 / t86 / t5;
  t211 = 0.5e1 / 0.24e2 * t25 * t208 * t44;
  t212 = t87 * params->prefactor;
  t213 = t25 * t212;
  t214 = t213 * t105;
  t217 = 0.1e1 / t94 / t41;
  t218 = t103 * t103;
  t220 = t93 * t217 * t218;
  t223 = t96 * rho[0];
  t225 = 0.1e1 / t34 / t223;
  t230 = 0.8e2 / 0.9e1 * tau[0] * t225 - 0.1e2 / 0.9e1 * lapl[0] * t225;
  t232 = t93 * t95 * t230;
  t236 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t197 * t26 * t44 - 0.5e1 / 0.8e1 * t202 + 0.15e2 / 0.8e1 * t204 * t105 + t211 + 0.5e1 / 0.8e1 * t214 - 0.15e2 / 0.8e1 * t92 * t220 + 0.15e2 / 0.16e2 * t92 * t232);
  t237 = t54 * t54;
  t238 = 0.1e1 / t237;
  t239 = t112 * t112;
  t242 = t49 * t188;
  t245 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t242);
  t249 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t54 * t245);
  t250 = t4 * t249;
  t255 = t116 * t87 * t70;
  t259 = 0.5e1 / 0.24e2 * t57 * t208 * t70;
  t261 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t250 * t26 * t70 - 0.5e1 / 0.8e1 * t255 + t259);
  tv2rho20 = 0.2e1 * t109 + 0.2e1 * t124 + t5 * (t236 + t261);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t264 = t183 * t128;
  t268 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t189);
  t272 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t264 * t78 + 0.4e1 / 0.3e1 * t22 * t268);
  t273 = t4 * t272;
  t278 = t132 * t87 * t44;
  t280 = t132 * t91;
  t286 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t273 * t26 * t44 - 0.5e1 / 0.16e2 * t278 + 0.15e2 / 0.16e2 * t280 * t105 - 0.5e1 / 0.16e2 * t202 + t211 + 0.5e1 / 0.16e2 * t214);
  t287 = t238 * t139;
  t291 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t242);
  t295 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t287 * t112 + 0.4e1 / 0.3e1 * t54 * t291);
  t296 = t4 * t295;
  t301 = t143 * t87 * t70;
  t304 = t116 * t91;
  t307 = t57 * t212;
  t308 = t307 * t159;
  t311 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t296 * t26 * t70 - 0.5e1 / 0.16e2 * t301 - 0.5e1 / 0.16e2 * t255 + t259 + 0.15e2 / 0.16e2 * t304 * t159 + 0.5e1 / 0.16e2 * t308);
  tv2rho21 = t109 + t124 + t137 + t163 + t5 * (t286 + t311);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t316 = t128 * t128;
  t321 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t189);
  t325 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t316 + 0.4e1 / 0.3e1 * t22 * t321);
  t326 = t4 * t325;
  t332 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t326 * t26 * t44 - 0.5e1 / 0.8e1 * t278 + t211);
  t333 = t139 * t139;
  t338 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t242);
  t342 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t333 + 0.4e1 / 0.3e1 * t54 * t338);
  t343 = t4 * t342;
  t348 = t143 * t91;
  t353 = 0.1e1 / t148 / t67;
  t354 = t157 * t157;
  t356 = t93 * t353 * t354;
  t359 = t150 * rho[1];
  t361 = 0.1e1 / t60 / t359;
  t366 = 0.8e2 / 0.9e1 * tau[1] * t361 - 0.1e2 / 0.9e1 * lapl[1] * t361;
  t368 = t93 * t149 * t366;
  t372 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t343 * t26 * t70 - 0.5e1 / 0.8e1 * t301 + 0.15e2 / 0.8e1 * t348 * t159 + t259 + 0.5e1 / 0.8e1 * t308 - 0.15e2 / 0.8e1 * t147 * t356 + 0.15e2 / 0.16e2 * t147 * t368);
  tv2rho22 = 0.2e1 * t137 + 0.2e1 * t163 + t5 * (t332 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  tv2rhosigma0 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  tv2rhosigma3 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t375 = t204 * t167;
  t377 = t213 * t167;
  t378 = 0.5e1 / 0.64e2 * t377;
  t379 = t217 * t36;
  t381 = t93 * t379 * t103;
  t382 = t92 * t381;
  t385 = t93 * t95 * t98;
  t386 = t92 * t385;
  t389 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t375 - t378 + 0.15e2 / 0.32e2 * t382 + 0.25e2 / 0.64e2 * t386);
  tv2rholapl0 = t5 * t389 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t391 = t304 * t172;
  t393 = t307 * t172;
  t394 = 0.5e1 / 0.64e2 * t393;
  t396 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t391 - t394);
  tv2rholapl1 = t5 * t396 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t398 = t280 * t167;
  t401 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t398 - t378);
  tv2rholapl2 = t5 * t401 + t170;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t403 = t348 * t172;
  t405 = t353 * t62;
  t407 = t93 * t405 * t157;
  t408 = t147 * t407;
  t411 = t93 * t149 * t152;
  t412 = t147 * t411;
  t415 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t403 - t394 + 0.15e2 / 0.32e2 * t408 + 0.25e2 / 0.64e2 * t412);
  tv2rholapl3 = t5 * t415 + t175;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t418 = 0.5e1 / 0.8e1 * t377;
  t422 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t375 + t418 - 0.15e2 / 0.4e1 * t382 - 0.25e2 / 0.8e1 * t386);
  tv2rhotau0 = t5 * t422 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t425 = 0.5e1 / 0.8e1 * t393;
  t427 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t391 + t425);
  tv2rhotau1 = t5 * t427 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t431 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t398 + t418);
  tv2rhotau2 = t5 * t431 + t177;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t437 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t403 + t425 - 0.15e2 / 0.4e1 * t408 - 0.25e2 / 0.8e1 * t412);
  tv2rhotau3 = t5 * t437 + t179;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  tv2sigma20 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t440 = 0.1e1 / t33 / t223;
  t442 = t93 * t217 * t440;
  t443 = t92 * t442;
  t445 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t443);
  tv2lapl20 = t5 * t445;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t447 = 0.1e1 / t59 / t359;
  t449 = t93 * t353 * t447;
  t450 = t147 * t449;
  t452 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t450);
  tv2lapl22 = t5 * t452;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t454 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t443);
  tv2lapltau0 = t5 * t454;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t456 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t450);
  tv2lapltau3 = t5 * t456;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t458 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t443);
  tv2tau20 = t5 * t458;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t460 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t450);
  tv2tau22 = t5 * t460;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t463 = t197 * t91;
  t467 = t82 * t208 * t44;
  t469 = t82 * t212;
  t470 = t469 * t105;
  t475 = 0.1e1 / t86 / t74;
  t478 = 0.25e2 / 0.72e2 * t25 * t475 * t44;
  t479 = t208 * params->prefactor;
  t480 = t25 * t479;
  t481 = t480 * t105;
  t483 = t213 * t232;
  t485 = t96 * t96;
  t487 = 0.1e1 / t34 / t485;
  t492 = -0.88e3 / 0.27e2 * tau[0] * t487 + 0.11e3 / 0.27e2 * lapl[0] * t487;
  t494 = t93 * t95 * t492;
  t498 = t197 * t87 * t44;
  t501 = 0.1e1 / t182 / t18;
  t502 = t184 * t78;
  t505 = t183 * t78;
  t508 = t74 * t74;
  t509 = 0.1e1 / t508;
  t510 = t15 * t509;
  t513 = my_piecewise5(t9, 0, t13, 0, 0.6e1 * t188 - 0.6e1 * t510);
  t517 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t501 * t502 + 0.4e1 / 0.3e1 * t505 * t192 + 0.4e1 / 0.3e1 * t22 * t513);
  t518 = t4 * t517;
  t524 = t213 * t220;
  t526 = t94 * t94;
  t527 = 0.1e1 / t526;
  t528 = t218 * t103;
  t530 = t93 * t527 * t528;
  t535 = t93 * t217 * t103 * t230;
  t538 = 0.45e2 / 0.16e2 * t463 * t105 + 0.5e1 / 0.8e1 * t467 + 0.15e2 / 0.8e1 * t470 + 0.45e2 / 0.16e2 * t204 * t232 - t478 - 0.5e1 / 0.8e1 * t481 + 0.15e2 / 0.16e2 * t483 + 0.15e2 / 0.16e2 * t92 * t494 - 0.15e2 / 0.16e2 * t498 - 0.15e2 / 0.16e2 * t518 * t26 * t44 - 0.45e2 / 0.8e1 * t204 * t220 - 0.15e2 / 0.8e1 * t524 + 0.45e2 / 0.8e1 * t92 * t530 - 0.45e2 / 0.8e1 * t92 * t535;
  t539 = my_piecewise3(t2, 0, t538);
  t541 = 0.1e1 / t237 / t52;
  t542 = t239 * t112;
  t545 = t238 * t112;
  t548 = t49 * t509;
  t551 = my_piecewise5(t13, 0, t9, 0, -0.6e1 * t188 - 0.6e1 * t548);
  t555 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t542 + 0.4e1 / 0.3e1 * t545 * t245 + 0.4e1 / 0.3e1 * t54 * t551);
  t556 = t4 * t555;
  t561 = t250 * t87 * t70;
  t564 = t116 * t208 * t70;
  t568 = 0.25e2 / 0.72e2 * t57 * t475 * t70;
  t570 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t556 * t26 * t70 - 0.15e2 / 0.16e2 * t561 + 0.5e1 / 0.8e1 * t564 - t568);
  tv3rho30 = 0.3e1 * t236 + 0.3e1 * t261 + t5 * (t539 + t570);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t573 = 0.2e1 * t286;
  t574 = 0.2e1 * t311;
  t575 = t501 * t128;
  t578 = t183 * t268;
  t583 = 0.2e1 * t188;
  t584 = 0.6e1 * t510;
  t586 = my_piecewise5(t9, 0, t13, 0, t583 - t584);
  t590 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t575 * t184 + 0.8e1 / 0.9e1 * t578 * t78 + 0.4e1 / 0.9e1 * t264 * t192 + 0.4e1 / 0.3e1 * t22 * t586);
  t591 = t4 * t590;
  t597 = 0.5e1 / 0.8e1 * t273 * t87 * t44;
  t598 = t273 * t91;
  t602 = t132 * t208 * t44;
  t604 = t132 * t212;
  t606 = 0.5e1 / 0.8e1 * t604 * t105;
  t617 = -0.15e2 / 0.16e2 * t591 * t26 * t44 - t597 + 0.15e2 / 0.8e1 * t598 * t105 + 0.5e1 / 0.24e2 * t602 + t606 - 0.15e2 / 0.8e1 * t280 * t220 + 0.15e2 / 0.16e2 * t280 * t232 - 0.5e1 / 0.16e2 * t498 + 0.5e1 / 0.12e2 * t467 + 0.5e1 / 0.8e1 * t470 - t478 - 0.5e1 / 0.12e2 * t481 - 0.5e1 / 0.8e1 * t524 + 0.5e1 / 0.16e2 * t483;
  t618 = my_piecewise3(t2, 0, t617);
  t619 = t541 * t139;
  t622 = t238 * t291;
  t627 = 0.6e1 * t548;
  t629 = my_piecewise5(t13, 0, t9, 0, -t583 - t627);
  t633 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t619 * t239 + 0.8e1 / 0.9e1 * t622 * t112 + 0.4e1 / 0.9e1 * t287 * t245 + 0.4e1 / 0.3e1 * t54 * t629);
  t634 = t4 * t633;
  t640 = 0.5e1 / 0.8e1 * t296 * t87 * t70;
  t642 = t143 * t208 * t70;
  t646 = t250 * t91;
  t649 = t116 * t212;
  t651 = 0.5e1 / 0.8e1 * t649 * t159;
  t652 = t57 * t479;
  t653 = t652 * t159;
  t656 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t634 * t26 * t70 - t640 + 0.5e1 / 0.24e2 * t642 - 0.5e1 / 0.16e2 * t561 + 0.5e1 / 0.12e2 * t564 - t568 + 0.15e2 / 0.16e2 * t646 * t159 + t651 - 0.5e1 / 0.24e2 * t653);
  tv3rho31 = t236 + t261 + t573 + t574 + t5 * (t618 + t656);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t659 = t501 * t316;
  t664 = t183 * t321;
  t668 = my_piecewise5(t9, 0, t13, 0, -t583 - t584);
  t672 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t659 * t78 + 0.8e1 / 0.9e1 * t264 * t268 + 0.4e1 / 0.9e1 * t664 * t78 + 0.4e1 / 0.3e1 * t22 * t668);
  t673 = t4 * t672;
  t678 = t326 * t87 * t44;
  t680 = t326 * t91;
  t687 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t673 * t26 * t44 - 0.5e1 / 0.16e2 * t678 + 0.15e2 / 0.16e2 * t680 * t105 - t597 + 0.5e1 / 0.12e2 * t602 + t606 + 0.5e1 / 0.24e2 * t467 - t478 - 0.5e1 / 0.24e2 * t481);
  t688 = t541 * t333;
  t693 = t238 * t338;
  t697 = my_piecewise5(t13, 0, t9, 0, t583 - t627);
  t701 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t688 * t112 + 0.8e1 / 0.9e1 * t287 * t291 + 0.4e1 / 0.9e1 * t693 * t112 + 0.4e1 / 0.3e1 * t54 * t697);
  t702 = t4 * t701;
  t707 = t343 * t87 * t70;
  t710 = t296 * t91;
  t713 = t143 * t212;
  t714 = t713 * t159;
  t720 = t307 * t356;
  t724 = t307 * t368;
  t726 = -0.15e2 / 0.16e2 * t702 * t26 * t70 - 0.5e1 / 0.16e2 * t707 - t640 + 0.5e1 / 0.12e2 * t642 + 0.15e2 / 0.8e1 * t710 * t159 + 0.5e1 / 0.8e1 * t714 + 0.5e1 / 0.24e2 * t564 - t568 + t651 - 0.5e1 / 0.12e2 * t653 - 0.15e2 / 0.8e1 * t304 * t356 - 0.5e1 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t304 * t368 + 0.5e1 / 0.16e2 * t724;
  t727 = my_piecewise3(t48, 0, t726);
  tv3rho32 = t573 + t574 + t332 + t372 + t5 * (t687 + t727);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t732 = t316 * t128;
  t739 = my_piecewise5(t9, 0, t13, 0, -0.6e1 * t188 - 0.6e1 * t510);
  t743 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t501 * t732 + 0.4e1 / 0.3e1 * t264 * t321 + 0.4e1 / 0.3e1 * t22 * t739);
  t744 = t4 * t743;
  t751 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t744 * t26 * t44 - 0.15e2 / 0.16e2 * t678 + 0.5e1 / 0.8e1 * t602 - t478);
  t752 = t333 * t139;
  t759 = my_piecewise5(t13, 0, t9, 0, 0.6e1 * t188 - 0.6e1 * t548);
  t763 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t752 + 0.4e1 / 0.3e1 * t287 * t338 + 0.4e1 / 0.3e1 * t54 * t759);
  t764 = t4 * t763;
  t768 = t150 * t150;
  t770 = 0.1e1 / t60 / t768;
  t775 = -0.88e3 / 0.27e2 * tau[1] * t770 + 0.11e3 / 0.27e2 * lapl[1] * t770;
  t777 = t93 * t149 * t775;
  t780 = t343 * t91;
  t789 = t148 * t148;
  t790 = 0.1e1 / t789;
  t791 = t354 * t157;
  t793 = t93 * t790 * t791;
  t798 = t93 * t353 * t157 * t366;
  t805 = -0.15e2 / 0.16e2 * t764 * t26 * t70 + 0.15e2 / 0.16e2 * t147 * t777 + 0.45e2 / 0.16e2 * t780 * t159 + 0.45e2 / 0.16e2 * t348 * t368 - 0.15e2 / 0.16e2 * t707 + 0.5e1 / 0.8e1 * t642 - t568 - 0.45e2 / 0.8e1 * t348 * t356 + 0.45e2 / 0.8e1 * t147 * t793 - 0.45e2 / 0.8e1 * t147 * t798 + 0.15e2 / 0.8e1 * t714 - 0.15e2 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t724 - 0.5e1 / 0.8e1 * t653;
  t806 = my_piecewise3(t48, 0, t805);
  tv3rho33 = 0.3e1 * t332 + 0.3e1 * t372 + t5 * (t751 + t806);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  tv3rho2sigma0 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  tv3rho2sigma3 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  tv3rho2sigma6 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t810 = t463 * t167;
  t812 = t469 * t167;
  t814 = t204 * t381;
  t816 = t204 * t385;
  t818 = t480 * t167;
  t819 = 0.5e1 / 0.96e2 * t818;
  t820 = t213 * t381;
  t822 = t213 * t385;
  t826 = t93 * t527 * t36 * t218;
  t827 = t92 * t826;
  t829 = t217 * t98;
  t831 = t93 * t829 * t103;
  t832 = t92 * t831;
  t835 = t93 * t379 * t230;
  t836 = t92 * t835;
  t839 = t93 * t95 * t225;
  t840 = t92 * t839;
  t842 = -0.15e2 / 0.64e2 * t810 - 0.5e1 / 0.32e2 * t812 + 0.15e2 / 0.16e2 * t814 + 0.25e2 / 0.32e2 * t816 + t819 + 0.5e1 / 0.16e2 * t820 + 0.25e2 / 0.96e2 * t822 - 0.45e2 / 0.32e2 * t827 - 0.25e2 / 0.16e2 * t832 + 0.15e2 / 0.32e2 * t836 - 0.25e2 / 0.24e2 * t840;
  t843 = my_piecewise3(t2, 0, t842);
  tv3rho2lapl0 = t5 * t843 + 0.2e1 * t389;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t846 = t646 * t172;
  t848 = t649 * t172;
  t850 = t652 * t172;
  t851 = 0.5e1 / 0.96e2 * t850;
  t853 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t846 - 0.5e1 / 0.32e2 * t848 + t851);
  tv3rho2lapl1 = t5 * t853 + 0.2e1 * t396;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t855 = t598 * t167;
  t857 = t604 * t167;
  t859 = t280 * t381;
  t861 = t280 * t385;
  t867 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t855 - 0.5e1 / 0.64e2 * t857 + 0.15e2 / 0.32e2 * t859 + 0.25e2 / 0.64e2 * t861 - 0.5e1 / 0.64e2 * t812 + t819 + 0.5e1 / 0.32e2 * t820 + 0.25e2 / 0.192e3 * t822);
  tv3rho2lapl2 = t5 * t867 + t389 + t401;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t869 = t710 * t172;
  t871 = t713 * t172;
  t874 = t304 * t407;
  t876 = t307 * t407;
  t878 = t304 * t411;
  t880 = t307 * t411;
  t883 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t869 - 0.5e1 / 0.64e2 * t871 - 0.5e1 / 0.64e2 * t848 + t851 + 0.15e2 / 0.32e2 * t874 + 0.5e1 / 0.32e2 * t876 + 0.25e2 / 0.64e2 * t878 + 0.25e2 / 0.192e3 * t880);
  tv3rho2lapl3 = t5 * t883 + t396 + t415;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t886 = t680 * t167;
  t890 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t886 - 0.5e1 / 0.32e2 * t857 + t819);
  tv3rho2lapl4 = t5 * t890 + 0.2e1 * t401;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t893 = t780 * t172;
  t896 = t348 * t407;
  t898 = t348 * t411;
  t904 = t93 * t790 * t62 * t354;
  t905 = t147 * t904;
  t907 = t353 * t152;
  t909 = t93 * t907 * t157;
  t910 = t147 * t909;
  t913 = t93 * t405 * t366;
  t914 = t147 * t913;
  t917 = t93 * t149 * t361;
  t918 = t147 * t917;
  t920 = -0.15e2 / 0.64e2 * t893 - 0.5e1 / 0.32e2 * t871 + 0.15e2 / 0.16e2 * t896 + 0.25e2 / 0.32e2 * t898 + t851 + 0.5e1 / 0.16e2 * t876 + 0.25e2 / 0.96e2 * t880 - 0.45e2 / 0.32e2 * t905 - 0.25e2 / 0.16e2 * t910 + 0.15e2 / 0.32e2 * t914 - 0.25e2 / 0.24e2 * t918;
  t921 = my_piecewise3(t48, 0, t920);
  tv3rho2lapl5 = t5 * t921 + 0.2e1 * t415;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t928 = 0.5e1 / 0.12e2 * t818;
  t935 = 0.15e2 / 0.8e1 * t810 + 0.5e1 / 0.4e1 * t812 - 0.15e2 / 0.2e1 * t814 - 0.25e2 / 0.4e1 * t816 - t928 - 0.5e1 / 0.2e1 * t820 - 0.25e2 / 0.12e2 * t822 + 0.45e2 / 0.4e1 * t827 + 0.25e2 / 0.2e1 * t832 - 0.15e2 / 0.4e1 * t836 + 0.25e2 / 0.3e1 * t840;
  t936 = my_piecewise3(t2, 0, t935);
  tv3rho2tau0 = t5 * t936 + 0.2e1 * t422;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t941 = 0.5e1 / 0.12e2 * t850;
  t943 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t846 + 0.5e1 / 0.4e1 * t848 - t941);
  tv3rho2tau1 = t5 * t943 + 0.2e1 * t427;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t953 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t855 + 0.5e1 / 0.8e1 * t857 - 0.15e2 / 0.4e1 * t859 - 0.25e2 / 0.8e1 * t861 + 0.5e1 / 0.8e1 * t812 - t928 - 0.5e1 / 0.4e1 * t820 - 0.25e2 / 0.24e2 * t822);
  tv3rho2tau2 = t5 * t953 + t422 + t431;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t963 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t869 + 0.5e1 / 0.8e1 * t871 + 0.5e1 / 0.8e1 * t848 - t941 - 0.15e2 / 0.4e1 * t874 - 0.5e1 / 0.4e1 * t876 - 0.25e2 / 0.8e1 * t878 - 0.25e2 / 0.24e2 * t880);
  tv3rho2tau3 = t5 * t963 + t427 + t437;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t969 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t886 + 0.5e1 / 0.4e1 * t857 - t928);
  tv3rho2tau4 = t5 * t969 + 0.2e1 * t431;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t982 = 0.15e2 / 0.8e1 * t893 + 0.5e1 / 0.4e1 * t871 - 0.15e2 / 0.2e1 * t896 - 0.25e2 / 0.4e1 * t898 - t941 - 0.5e1 / 0.2e1 * t876 - 0.25e2 / 0.12e2 * t880 + 0.45e2 / 0.4e1 * t905 + 0.25e2 / 0.2e1 * t910 - 0.15e2 / 0.4e1 * t914 + 0.25e2 / 0.3e1 * t918;
  t983 = my_piecewise3(t48, 0, t982);
  tv3rho2tau5 = t5 * t983 + 0.2e1 * t437;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  tv3rhosigma20 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t985 = t204 * t442;
  t987 = t213 * t442;
  t988 = 0.5e1 / 0.128e3 * t987;
  t989 = t527 * t440;
  t991 = t93 * t989 * t103;
  t992 = t92 * t991;
  t995 = 0.1e1 / t33 / t485;
  t997 = t93 * t217 * t995;
  t998 = t92 * t997;
  t1001 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t985 - t988 + 0.45e2 / 0.128e3 * t992 + 0.25e2 / 0.64e2 * t998);
  tv3rholapl20 = t5 * t1001 + t445;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t1003 = t304 * t449;
  t1005 = t307 * t449;
  t1006 = 0.5e1 / 0.128e3 * t1005;
  t1008 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1003 - t1006);
  tv3rholapl22 = t5 * t1008 + t452;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t1010 = t280 * t442;
  t1013 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t1010 - t988);
  tv3rholapl23 = t5 * t1013 + t445;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t1015 = t348 * t449;
  t1017 = t790 * t447;
  t1019 = t93 * t1017 * t157;
  t1020 = t147 * t1019;
  t1023 = 0.1e1 / t59 / t768;
  t1025 = t93 * t353 * t1023;
  t1026 = t147 * t1025;
  t1029 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1015 - t1006 + 0.45e2 / 0.128e3 * t1020 + 0.25e2 / 0.64e2 * t1026);
  tv3rholapl25 = t5 * t1029 + t452;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t1032 = 0.5e1 / 0.16e2 * t987;
  t1036 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t985 + t1032 - 0.45e2 / 0.16e2 * t992 - 0.25e2 / 0.8e1 * t998);
  tv3rholapltau0 = t5 * t1036 + t454;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t1039 = 0.5e1 / 0.16e2 * t1005;
  t1041 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1003 + t1039);
  tv3rholapltau3 = t5 * t1041 + t456;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t1045 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t1010 + t1032);
  tv3rholapltau4 = t5 * t1045 + t454;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t1051 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1015 + t1039 - 0.45e2 / 0.16e2 * t1020 - 0.25e2 / 0.8e1 * t1026);
  tv3rholapltau7 = t5 * t1051 + t456;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t1054 = 0.5e1 / 0.2e1 * t987;
  t1058 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t985 - t1054 + 0.45e2 / 0.2e1 * t992 + 0.25e2 * t998);
  tv3rhotau20 = t5 * t1058 + t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t1061 = 0.5e1 / 0.2e1 * t1005;
  t1063 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1003 - t1061);
  tv3rhotau22 = t5 * t1063 + t460;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t1067 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t1010 - t1054);
  tv3rhotau23 = t5 * t1067 + t458;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t1073 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1015 - t1061 + 0.45e2 / 0.2e1 * t1020 + 0.25e2 * t1026);
  tv3rhotau25 = t5 * t1073 + t460;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  tv3sigma30 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t1075 = t485 * rho[0];
  t1076 = 0.1e1 / t1075;
  t1078 = t93 * t527 * t1076;
  t1079 = t92 * t1078;
  t1081 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t1079);
  tv3lapl30 = t5 * t1081;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t1082 = t768 * rho[1];
  t1083 = 0.1e1 / t1082;
  t1085 = t93 * t790 * t1083;
  t1086 = t147 * t1085;
  t1088 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t1086);
  tv3lapl33 = t5 * t1088;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t1090 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t1079);
  tv3lapl2tau0 = t5 * t1090;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t1092 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t1086);
  tv3lapl2tau5 = t5 * t1092;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t1094 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t1079);
  tv3lapltau20 = t5 * t1094;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t1096 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t1086);
  tv3lapltau25 = t5 * t1096;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t1098 = my_piecewise3(t2, 0, 0.45e2 * t1079);
  tv3tau30 = t5 * t1098;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t1100 = my_piecewise3(t48, 0, 0.45e2 * t1086);
  tv3tau33 = t5 * t1100;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t1104 = t197 * t208 * t44;
  t1107 = t518 * t87 * t44;
  t1109 = t18 * t18;
  t1111 = 0.1e1 / t182 / t1109;
  t1112 = t184 * t184;
  t1118 = t192 * t192;
  t1124 = 0.1e1 / t508 / t5;
  t1125 = t15 * t1124;
  t1128 = my_piecewise5(t9, 0, t13, 0, -0.24e2 * t509 + 0.24e2 * t1125);
  t1132 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1111 * t1112 - 0.16e2 / 0.9e1 * t501 * t184 * t192 + 0.4e1 / 0.3e1 * t183 * t1118 + 0.16e2 / 0.9e1 * t505 * t513 + 0.4e1 / 0.3e1 * t22 * t1128);
  t1138 = t82 * t475 * t44;
  t1141 = 0.1e1 / t86 / t187;
  t1144 = 0.25e2 / 0.27e2 * t25 * t1141 * t44;
  t1152 = t213 * t535;
  t1160 = 0.1e1 / t34 / t1075;
  t1171 = 0.1e1 / t526 / t41;
  t1172 = t218 * t218;
  t1177 = t230 * t230;
  t1184 = 0.5e1 / 0.4e1 * t1104 - 0.5e1 / 0.4e1 * t1107 - 0.15e2 / 0.16e2 * t4 * t1132 * t26 * t44 - 0.25e2 / 0.18e2 * t1138 + t1144 - 0.45e2 / 0.2e1 * t204 * t535 + 0.135e3 / 0.4e1 * t92 * t93 * t527 * t218 * t230 - 0.15e2 / 0.2e1 * t1152 - 0.15e2 / 0.2e1 * t92 * t93 * t217 * t492 * t103 + 0.15e2 / 0.16e2 * t92 * t93 * t95 * (0.1232e5 / 0.81e2 * tau[0] * t1160 - 0.154e4 / 0.81e2 * lapl[0] * t1160) - 0.45e2 / 0.2e1 * t92 * t93 * t1171 * t1172 - 0.45e2 / 0.8e1 * t92 * t93 * t217 * t1177 + 0.45e2 / 0.2e1 * t204 * t530;
  t1185 = t213 * t530;
  t1187 = t197 * t212;
  t1188 = t1187 * t105;
  t1192 = t469 * t220;
  t1194 = t480 * t220;
  t1198 = t82 * t479;
  t1199 = t1198 * t105;
  t1201 = t469 * t232;
  t1205 = t475 * params->prefactor;
  t1206 = t25 * t1205;
  t1207 = t1206 * t105;
  t1209 = t480 * t232;
  t1211 = t213 * t494;
  t1213 = t518 * t91;
  t1216 = 0.15e2 / 0.2e1 * t1185 + 0.15e2 / 0.4e1 * t1188 - 0.45e2 / 0.4e1 * t463 * t220 - 0.15e2 / 0.2e1 * t1192 + 0.5e1 / 0.2e1 * t1194 + 0.45e2 / 0.8e1 * t463 * t232 - 0.5e1 / 0.2e1 * t1199 + 0.15e2 / 0.4e1 * t1201 + 0.15e2 / 0.4e1 * t204 * t494 + 0.25e2 / 0.18e2 * t1207 - 0.5e1 / 0.4e1 * t1209 + 0.5e1 / 0.4e1 * t1211 + 0.15e2 / 0.4e1 * t1213 * t105;
  t1218 = my_piecewise3(t2, 0, t1184 + t1216);
  t1219 = t52 * t52;
  t1221 = 0.1e1 / t237 / t1219;
  t1222 = t239 * t239;
  t1228 = t245 * t245;
  t1233 = t49 * t1124;
  t1236 = my_piecewise5(t13, 0, t9, 0, 0.24e2 * t509 + 0.24e2 * t1233);
  t1240 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1221 * t1222 - 0.16e2 / 0.9e1 * t541 * t239 * t245 + 0.4e1 / 0.3e1 * t238 * t1228 + 0.16e2 / 0.9e1 * t545 * t551 + 0.4e1 / 0.3e1 * t54 * t1236);
  t1246 = t556 * t87 * t70;
  t1249 = t250 * t208 * t70;
  t1252 = t116 * t475 * t70;
  t1256 = 0.25e2 / 0.27e2 * t57 * t1141 * t70;
  t1258 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t4 * t1240 * t26 * t70 - 0.5e1 / 0.4e1 * t1246 + 0.5e1 / 0.4e1 * t1249 - 0.25e2 / 0.18e2 * t1252 + t1256);
  tv4rho40 = 0.4e1 * t539 + 0.4e1 * t570 + t5 * (t1218 + t1258);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1267 = t591 * t87 * t44;
  t1270 = t273 * t208 * t44;
  t1271 = 0.5e1 / 0.8e1 * t1270;
  t1273 = t132 * t475 * t44;
  t1291 = 0.12e2 * t509;
  t1292 = 0.24e2 * t1125;
  t1294 = my_piecewise5(t9, 0, t13, 0, -t1291 + t1292);
  t1298 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1111 * t128 * t502 - 0.8e1 / 0.9e1 * t501 * t268 * t184 - 0.8e1 / 0.9e1 * t575 * t78 * t192 + 0.4e1 / 0.3e1 * t183 * t586 * t78 + 0.4e1 / 0.3e1 * t578 * t192 + 0.4e1 / 0.9e1 * t264 * t513 + 0.4e1 / 0.3e1 * t22 * t1294);
  t1310 = 0.5e1 / 0.8e1 * t1104 - 0.5e1 / 0.16e2 * t1107 - 0.25e2 / 0.24e2 * t1138 + t1144 - 0.15e2 / 0.16e2 * t1267 + t1271 - 0.25e2 / 0.72e2 * t1273 - 0.15e2 / 0.16e2 * t4 * t1298 * t26 * t44 - 0.45e2 / 0.8e1 * t280 * t535 - 0.15e2 / 0.8e1 * t1152 + 0.15e2 / 0.8e1 * t1185 + 0.15e2 / 0.16e2 * t1188 - 0.15e2 / 0.8e1 * t1192 + 0.5e1 / 0.4e1 * t1194;
  t1318 = t591 * t91;
  t1321 = t273 * t212;
  t1322 = t1321 * t105;
  t1326 = t132 * t479;
  t1327 = t1326 * t105;
  t1328 = 0.5e1 / 0.8e1 * t1327;
  t1329 = t604 * t232;
  t1331 = t604 * t220;
  t1337 = -0.5e1 / 0.4e1 * t1199 + 0.15e2 / 0.16e2 * t1201 + 0.25e2 / 0.24e2 * t1207 - 0.5e1 / 0.8e1 * t1209 + 0.5e1 / 0.16e2 * t1211 + 0.15e2 / 0.16e2 * t280 * t494 + 0.45e2 / 0.16e2 * t1318 * t105 + 0.15e2 / 0.8e1 * t1322 + 0.45e2 / 0.16e2 * t598 * t232 - t1328 + 0.15e2 / 0.16e2 * t1329 - 0.15e2 / 0.8e1 * t1331 + 0.45e2 / 0.8e1 * t280 * t530 - 0.45e2 / 0.8e1 * t598 * t220;
  t1339 = my_piecewise3(t2, 0, t1310 + t1337);
  t1356 = 0.24e2 * t1233;
  t1358 = my_piecewise5(t13, 0, t9, 0, t1291 + t1356);
  t1362 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1221 * t139 * t542 - 0.8e1 / 0.9e1 * t541 * t291 * t239 - 0.8e1 / 0.9e1 * t619 * t112 * t245 + 0.4e1 / 0.3e1 * t238 * t629 * t112 + 0.4e1 / 0.3e1 * t622 * t245 + 0.4e1 / 0.9e1 * t287 * t551 + 0.4e1 / 0.3e1 * t54 * t1358);
  t1368 = t634 * t87 * t70;
  t1371 = t296 * t208 * t70;
  t1372 = 0.5e1 / 0.8e1 * t1371;
  t1374 = t143 * t475 * t70;
  t1379 = t556 * t91;
  t1382 = t250 * t212;
  t1383 = t1382 * t159;
  t1385 = t116 * t479;
  t1386 = t1385 * t159;
  t1387 = 0.5e1 / 0.8e1 * t1386;
  t1388 = t57 * t1205;
  t1389 = t1388 * t159;
  t1391 = -0.15e2 / 0.16e2 * t4 * t1362 * t26 * t70 - 0.15e2 / 0.16e2 * t1368 + t1372 - 0.25e2 / 0.72e2 * t1374 - 0.5e1 / 0.16e2 * t1246 + 0.5e1 / 0.8e1 * t1249 - 0.25e2 / 0.24e2 * t1252 + t1256 + 0.15e2 / 0.16e2 * t1379 * t159 + 0.15e2 / 0.16e2 * t1383 - t1387 + 0.25e2 / 0.72e2 * t1389;
  t1392 = my_piecewise3(t48, 0, t1391);
  tv4rho41 = t539 + t570 + 0.3e1 * t618 + 0.3e1 * t656 + t5 * (t1339 + t1392);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1400 = t673 * t87 * t44;
  t1402 = t673 * t91;
  t1406 = t326 * t208 * t44;
  t1408 = t326 * t212;
  t1409 = t1408 * t105;
  t1432 = t268 * t268;
  t1445 = my_piecewise5(t9, 0, t13, 0, t1292);
  t1449 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1111 * t316 * t184 - 0.32e2 / 0.27e2 * t575 * t78 * t268 - 0.8e1 / 0.27e2 * t659 * t192 + 0.8e1 / 0.9e1 * t183 * t1432 + 0.8e1 / 0.9e1 * t264 * t586 - 0.8e1 / 0.27e2 * t501 * t321 * t184 + 0.8e1 / 0.9e1 * t183 * t668 * t78 + 0.4e1 / 0.9e1 * t664 * t192 + 0.4e1 / 0.3e1 * t22 * t1445);
  t1459 = 0.5e1 / 0.8e1 * t1329 - 0.15e2 / 0.8e1 * t680 * t220 - 0.5e1 / 0.4e1 * t1331 + 0.5e1 / 0.12e2 * t1194 - 0.15e2 / 0.16e2 * t4 * t1449 * t26 * t44 + 0.5e1 / 0.24e2 * t1104 - 0.25e2 / 0.36e2 * t1138 - 0.5e1 / 0.12e2 * t1199 + t1144 + 0.25e2 / 0.36e2 * t1207 - 0.5e1 / 0.24e2 * t1209;
  t1461 = my_piecewise3(t2, 0, -0.5e1 / 0.8e1 * t1400 + 0.15e2 / 0.8e1 * t1402 * t105 + 0.5e1 / 0.24e2 * t1406 + 0.5e1 / 0.8e1 * t1409 + 0.15e2 / 0.16e2 * t680 * t232 - 0.5e1 / 0.8e1 * t1267 + 0.5e1 / 0.6e1 * t1270 + 0.5e1 / 0.4e1 * t1322 - 0.25e2 / 0.36e2 * t1273 - 0.5e1 / 0.6e1 * t1327 + t1459);
  t1462 = t634 * t91;
  t1470 = t702 * t87 * t70;
  t1473 = t343 * t208 * t70;
  t1481 = t143 * t479;
  t1482 = t1481 * t159;
  t1484 = t649 * t356;
  t1486 = t652 * t356;
  t1488 = t649 * t368;
  t1490 = t652 * t368;
  t1493 = t296 * t212;
  t1494 = t1493 * t159;
  t1506 = t291 * t291;
  t1519 = my_piecewise5(t13, 0, t9, 0, t1356);
  t1523 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1221 * t333 * t239 - 0.32e2 / 0.27e2 * t619 * t112 * t291 - 0.8e1 / 0.27e2 * t688 * t245 + 0.8e1 / 0.9e1 * t238 * t1506 + 0.8e1 / 0.9e1 * t287 * t629 - 0.8e1 / 0.27e2 * t541 * t338 * t239 + 0.8e1 / 0.9e1 * t238 * t697 * t112 + 0.4e1 / 0.9e1 * t693 * t245 + 0.4e1 / 0.3e1 * t54 * t1519);
  t1528 = t1256 - 0.5e1 / 0.12e2 * t1482 - 0.5e1 / 0.4e1 * t1484 + 0.5e1 / 0.12e2 * t1486 + 0.5e1 / 0.8e1 * t1488 - 0.5e1 / 0.24e2 * t1490 + 0.25e2 / 0.36e2 * t1389 + 0.5e1 / 0.4e1 * t1494 + 0.5e1 / 0.8e1 * t1383 - 0.5e1 / 0.6e1 * t1386 - 0.15e2 / 0.16e2 * t4 * t1523 * t26 * t70;
  t1530 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t1462 * t159 - 0.15e2 / 0.8e1 * t646 * t356 + 0.15e2 / 0.16e2 * t646 * t368 - 0.5e1 / 0.8e1 * t1470 + 0.5e1 / 0.24e2 * t1473 - 0.5e1 / 0.8e1 * t1368 + 0.5e1 / 0.6e1 * t1371 - 0.25e2 / 0.36e2 * t1374 + 0.5e1 / 0.24e2 * t1249 - 0.25e2 / 0.36e2 * t1252 + t1528);
  tv4rho42 = 0.2e1 * t618 + 0.2e1 * t656 + 0.2e1 * t687 + 0.2e1 * t727 + t5 * (t1461 + t1530);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1551 = my_piecewise5(t9, 0, t13, 0, t1291 + t1292);
  t1555 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1111 * t732 * t78 - 0.8e1 / 0.9e1 * t659 * t268 - 0.8e1 / 0.9e1 * t575 * t321 * t78 + 0.4e1 / 0.3e1 * t578 * t321 + 0.4e1 / 0.3e1 * t264 * t668 + 0.4e1 / 0.9e1 * t183 * t739 * t78 + 0.4e1 / 0.3e1 * t22 * t1551);
  t1561 = t744 * t87 * t44;
  t1563 = t744 * t91;
  t1572 = -0.15e2 / 0.16e2 * t4 * t1555 * t26 * t44 - 0.5e1 / 0.16e2 * t1561 + 0.15e2 / 0.16e2 * t1563 * t105 - 0.15e2 / 0.16e2 * t1400 + 0.5e1 / 0.8e1 * t1406 + 0.15e2 / 0.16e2 * t1409 + t1271 - 0.25e2 / 0.24e2 * t1273 - t1328 - 0.25e2 / 0.72e2 * t1138 + t1144 + 0.25e2 / 0.72e2 * t1207;
  t1573 = my_piecewise3(t2, 0, t1572);
  t1575 = t764 * t87 * t70;
  t1593 = my_piecewise5(t13, 0, t9, 0, -t1291 + t1356);
  t1597 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1221 * t752 * t112 - 0.8e1 / 0.9e1 * t688 * t291 - 0.8e1 / 0.9e1 * t619 * t338 * t112 + 0.4e1 / 0.3e1 * t622 * t338 + 0.4e1 / 0.3e1 * t287 * t697 + 0.4e1 / 0.9e1 * t238 * t759 * t112 + 0.4e1 / 0.3e1 * t54 * t1593);
  t1606 = t307 * t798;
  t1613 = -0.5e1 / 0.16e2 * t1575 - 0.15e2 / 0.16e2 * t4 * t1597 * t26 * t70 + t1372 - 0.25e2 / 0.24e2 * t1374 - 0.15e2 / 0.16e2 * t1470 + 0.5e1 / 0.8e1 * t1473 - 0.25e2 / 0.72e2 * t1252 + t1256 - 0.15e2 / 0.8e1 * t1606 - 0.45e2 / 0.8e1 * t304 * t798 - t1387 + 0.25e2 / 0.24e2 * t1389 - 0.5e1 / 0.4e1 * t1482 - 0.15e2 / 0.8e1 * t1484;
  t1620 = t702 * t91;
  t1629 = t307 * t793;
  t1631 = t307 * t777;
  t1633 = t343 * t212;
  t1634 = t1633 * t159;
  t1636 = t713 * t368;
  t1638 = t713 * t356;
  t1640 = 0.5e1 / 0.4e1 * t1486 + 0.15e2 / 0.16e2 * t1488 - 0.5e1 / 0.8e1 * t1490 + 0.15e2 / 0.8e1 * t1494 + 0.15e2 / 0.16e2 * t304 * t777 + 0.45e2 / 0.16e2 * t1620 * t159 + 0.45e2 / 0.16e2 * t710 * t368 - 0.45e2 / 0.8e1 * t710 * t356 + 0.45e2 / 0.8e1 * t304 * t793 + 0.15e2 / 0.8e1 * t1629 + 0.5e1 / 0.16e2 * t1631 + 0.15e2 / 0.16e2 * t1634 + 0.15e2 / 0.16e2 * t1636 - 0.15e2 / 0.8e1 * t1638;
  t1642 = my_piecewise3(t48, 0, t1613 + t1640);
  tv4rho43 = 0.3e1 * t687 + 0.3e1 * t727 + t751 + t806 + t5 * (t1573 + t1642);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1647 = t316 * t316;
  t1652 = t321 * t321;
  t1659 = my_piecewise5(t9, 0, t13, 0, 0.24e2 * t509 + 0.24e2 * t1125);
  t1663 = my_piecewise3(t19, 0, 0.4e2 / 0.81e2 * t1111 * t1647 - 0.16e2 / 0.9e1 * t659 * t321 + 0.4e1 / 0.3e1 * t183 * t1652 + 0.16e2 / 0.9e1 * t264 * t739 + 0.4e1 / 0.3e1 * t22 * t1659);
  t1672 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t4 * t1663 * t26 * t44 - 0.5e1 / 0.4e1 * t1561 + 0.5e1 / 0.4e1 * t1406 - 0.25e2 / 0.18e2 * t1273 + t1144);
  t1674 = t333 * t333;
  t1679 = t338 * t338;
  t1686 = my_piecewise5(t13, 0, t9, 0, -0.24e2 * t509 + 0.24e2 * t1233);
  t1690 = my_piecewise3(t53, 0, 0.4e2 / 0.81e2 * t1221 * t1674 - 0.16e2 / 0.9e1 * t688 * t338 + 0.4e1 / 0.3e1 * t238 * t1679 + 0.16e2 / 0.9e1 * t287 * t759 + 0.4e1 / 0.3e1 * t54 * t1686);
  t1714 = -0.5e1 / 0.4e1 * t1575 - 0.15e2 / 0.16e2 * t4 * t1690 * t26 * t70 - 0.25e2 / 0.18e2 * t1374 + 0.5e1 / 0.4e1 * t1473 + t1256 - 0.45e2 / 0.2e1 * t348 * t798 - 0.15e2 / 0.2e1 * t1606 + 0.135e3 / 0.4e1 * t147 * t93 * t790 * t354 * t366 - 0.15e2 / 0.2e1 * t147 * t93 * t353 * t775 * t157 + 0.25e2 / 0.18e2 * t1389 - 0.5e1 / 0.2e1 * t1482 + 0.5e1 / 0.2e1 * t1486 - 0.5e1 / 0.4e1 * t1490;
  t1720 = t366 * t366;
  t1730 = 0.1e1 / t789 / t67;
  t1731 = t354 * t354;
  t1736 = t764 * t91;
  t1742 = 0.1e1 / t60 / t1082;
  t1754 = 0.15e2 / 0.2e1 * t1629 + 0.5e1 / 0.4e1 * t1631 + 0.15e2 / 0.4e1 * t1634 + 0.15e2 / 0.4e1 * t1636 - 0.15e2 / 0.2e1 * t1638 - 0.45e2 / 0.8e1 * t147 * t93 * t353 * t1720 - 0.45e2 / 0.4e1 * t780 * t356 + 0.45e2 / 0.2e1 * t348 * t793 - 0.45e2 / 0.2e1 * t147 * t93 * t1730 * t1731 + 0.15e2 / 0.4e1 * t1736 * t159 + 0.15e2 / 0.4e1 * t348 * t777 + 0.15e2 / 0.16e2 * t147 * t93 * t149 * (0.1232e5 / 0.81e2 * tau[1] * t1742 - 0.154e4 / 0.81e2 * lapl[1] * t1742) + 0.45e2 / 0.8e1 * t780 * t368;
  t1756 = my_piecewise3(t48, 0, t1714 + t1754);
  tv4rho44 = 0.4e1 * t751 + 0.4e1 * t806 + t5 * (t1672 + t1756);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  tv4rho3sigma0 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  tv4rho3sigma3 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  tv4rho3sigma5 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  tv4rho3sigma6 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  tv4rho3sigma8 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  tv4rho3sigma9 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  tv4rho3sigma11 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t1760 = t91 * t30;
  t1766 = t25 * t1760 * t32 * t527 * t36 * t103 * t230;
  t1768 = t213 * t835;
  t1772 = t92 * t93 * t829 * t230;
  t1776 = t92 * t93 * t379 * t492;
  t1778 = t463 * t381;
  t1780 = t469 * t381;
  t1782 = t204 * t835;
  t1784 = t213 * t826;
  t1786 = t213 * t831;
  t1791 = t92 * t93 * t1171 * t36 * t528;
  t1796 = t92 * t93 * t527 * t98 * t218;
  t1801 = t92 * t93 * t217 * t225 * t103;
  t1803 = -0.135e3 / 0.32e2 * t1766 + 0.15e2 / 0.32e2 * t1768 - 0.75e2 / 0.32e2 * t1772 + 0.15e2 / 0.32e2 * t1776 + 0.45e2 / 0.32e2 * t1778 + 0.15e2 / 0.16e2 * t1780 + 0.45e2 / 0.32e2 * t1782 - 0.45e2 / 0.32e2 * t1784 - 0.25e2 / 0.16e2 * t1786 + 0.45e2 / 0.8e1 * t1791 + 0.225e3 / 0.32e2 * t1796 + 0.25e2 / 0.4e1 * t1801;
  t1804 = t204 * t826;
  t1806 = t204 * t831;
  t1808 = t480 * t381;
  t1812 = t92 * t93 * t95 * t487;
  t1814 = t480 * t385;
  t1816 = t213 * t839;
  t1818 = t1187 * t167;
  t1820 = t463 * t385;
  t1822 = t1198 * t167;
  t1824 = t469 * t385;
  t1826 = t204 * t839;
  t1828 = t1206 * t167;
  t1829 = 0.25e2 / 0.288e3 * t1828;
  t1830 = t1213 * t167;
  t1832 = -0.135e3 / 0.32e2 * t1804 - 0.75e2 / 0.16e2 * t1806 - 0.5e1 / 0.16e2 * t1808 + 0.275e3 / 0.72e2 * t1812 - 0.25e2 / 0.96e2 * t1814 - 0.25e2 / 0.24e2 * t1816 - 0.15e2 / 0.64e2 * t1818 + 0.75e2 / 0.64e2 * t1820 + 0.5e1 / 0.32e2 * t1822 + 0.25e2 / 0.32e2 * t1824 - 0.25e2 / 0.8e1 * t1826 - t1829 - 0.15e2 / 0.64e2 * t1830;
  t1834 = my_piecewise3(t2, 0, t1803 + t1832);
  tv4rho3lapl0 = t5 * t1834 + 0.3e1 * t843;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t1837 = t1379 * t172;
  t1839 = t1382 * t172;
  t1841 = t1385 * t172;
  t1843 = t1388 * t172;
  t1844 = 0.25e2 / 0.288e3 * t1843;
  t1846 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t1837 - 0.15e2 / 0.64e2 * t1839 + 0.5e1 / 0.32e2 * t1841 - t1844);
  tv4rho3lapl1 = t5 * t1846 + 0.3e1 * t853;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t1848 = 0.2e1 * t867;
  t1849 = t1321 * t167;
  t1850 = 0.5e1 / 0.32e2 * t1849;
  t1851 = t598 * t381;
  t1853 = t598 * t385;
  t1855 = t1326 * t167;
  t1857 = t604 * t381;
  t1858 = 0.5e1 / 0.16e2 * t1857;
  t1859 = t604 * t385;
  t1860 = 0.25e2 / 0.96e2 * t1859;
  t1861 = t280 * t835;
  t1863 = t280 * t839;
  t1868 = -t1850 + 0.15e2 / 0.16e2 * t1851 + 0.25e2 / 0.32e2 * t1853 + 0.5e1 / 0.96e2 * t1855 + t1858 + t1860 + 0.15e2 / 0.32e2 * t1861 - 0.25e2 / 0.24e2 * t1863 - 0.5e1 / 0.24e2 * t1808 - 0.25e2 / 0.144e3 * t1814 + 0.5e1 / 0.32e2 * t1768;
  t1874 = t1318 * t167;
  t1876 = t280 * t826;
  t1878 = t280 * t831;
  t1882 = -0.25e2 / 0.72e2 * t1816 - 0.5e1 / 0.64e2 * t1818 + 0.5e1 / 0.48e2 * t1822 + 0.5e1 / 0.16e2 * t1780 + 0.25e2 / 0.96e2 * t1824 - t1829 - 0.15e2 / 0.64e2 * t1874 - 0.45e2 / 0.32e2 * t1876 - 0.25e2 / 0.16e2 * t1878 - 0.15e2 / 0.32e2 * t1784 - 0.25e2 / 0.48e2 * t1786;
  t1884 = my_piecewise3(t2, 0, t1868 + t1882);
  tv4rho3lapl2 = t5 * t1884 + t1848 + t843;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t1886 = 0.2e1 * t883;
  t1887 = t1462 * t172;
  t1889 = t1493 * t172;
  t1890 = 0.5e1 / 0.32e2 * t1889;
  t1891 = t1481 * t172;
  t1895 = t646 * t407;
  t1897 = t649 * t407;
  t1898 = 0.5e1 / 0.16e2 * t1897;
  t1899 = t652 * t407;
  t1901 = t646 * t411;
  t1903 = t649 * t411;
  t1904 = 0.25e2 / 0.96e2 * t1903;
  t1905 = t652 * t411;
  t1907 = -0.15e2 / 0.64e2 * t1887 - t1890 + 0.5e1 / 0.96e2 * t1891 - 0.5e1 / 0.64e2 * t1839 + 0.5e1 / 0.48e2 * t1841 - t1844 + 0.15e2 / 0.32e2 * t1895 + t1898 - 0.5e1 / 0.48e2 * t1899 + 0.25e2 / 0.64e2 * t1901 + t1904 - 0.25e2 / 0.288e3 * t1905;
  t1908 = my_piecewise3(t48, 0, t1907);
  tv4rho3lapl3 = t5 * t1908 + t1886 + t853;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t1910 = t1402 * t167;
  t1912 = t1408 * t167;
  t1914 = t680 * t381;
  t1916 = t680 * t385;
  t1922 = -0.15e2 / 0.64e2 * t1910 - 0.5e1 / 0.64e2 * t1912 + 0.15e2 / 0.32e2 * t1914 + 0.25e2 / 0.64e2 * t1916 - t1850 + 0.5e1 / 0.48e2 * t1855 + t1858 + t1860 + 0.5e1 / 0.96e2 * t1822 - t1829 - 0.5e1 / 0.48e2 * t1808 - 0.25e2 / 0.288e3 * t1814;
  t1923 = my_piecewise3(t2, 0, t1922);
  tv4rho3lapl4 = t5 * t1923 + t1848 + t890;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t1925 = t1620 * t172;
  t1927 = t1633 * t172;
  t1930 = t710 * t407;
  t1932 = t713 * t407;
  t1934 = t710 * t411;
  t1936 = t713 * t411;
  t1939 = -0.15e2 / 0.64e2 * t1925 - 0.5e1 / 0.64e2 * t1927 - t1890 + 0.5e1 / 0.48e2 * t1891 + 0.15e2 / 0.16e2 * t1930 + 0.5e1 / 0.16e2 * t1932 + 0.25e2 / 0.32e2 * t1934 + 0.25e2 / 0.96e2 * t1936 + 0.5e1 / 0.96e2 * t1841 - t1844 + t1898;
  t1942 = t304 * t904;
  t1944 = t307 * t904;
  t1946 = t304 * t909;
  t1948 = t307 * t909;
  t1950 = t304 * t913;
  t1952 = t307 * t913;
  t1954 = t304 * t917;
  t1956 = t307 * t917;
  t1958 = -0.5e1 / 0.24e2 * t1899 + t1904 - 0.25e2 / 0.144e3 * t1905 - 0.45e2 / 0.32e2 * t1942 - 0.15e2 / 0.32e2 * t1944 - 0.25e2 / 0.16e2 * t1946 - 0.25e2 / 0.48e2 * t1948 + 0.15e2 / 0.32e2 * t1950 + 0.5e1 / 0.32e2 * t1952 - 0.25e2 / 0.24e2 * t1954 - 0.25e2 / 0.72e2 * t1956;
  t1960 = my_piecewise3(t48, 0, t1939 + t1958);
  tv4rho3lapl5 = t5 * t1960 + t1886 + t921;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t1963 = t1563 * t167;
  t1968 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t1963 - 0.15e2 / 0.64e2 * t1912 + 0.5e1 / 0.32e2 * t1855 - t1829);
  tv4rho3lapl6 = t5 * t1968 + 0.3e1 * t890;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t1976 = t57 * t1760 * t32 * t790 * t62 * t157 * t366;
  t1981 = t147 * t93 * t1730 * t62 * t791;
  t1986 = t147 * t93 * t790 * t152 * t354;
  t1991 = t147 * t93 * t353 * t361 * t157;
  t1993 = t348 * t904;
  t1995 = t348 * t909;
  t2002 = t147 * t93 * t405 * t775;
  t2006 = t147 * t93 * t907 * t366;
  t2008 = t780 * t407;
  t2010 = -0.135e3 / 0.32e2 * t1976 + 0.45e2 / 0.8e1 * t1981 + 0.225e3 / 0.32e2 * t1986 + 0.25e2 / 0.4e1 * t1991 - 0.135e3 / 0.32e2 * t1993 - 0.75e2 / 0.16e2 * t1995 - 0.45e2 / 0.32e2 * t1944 - 0.25e2 / 0.16e2 * t1948 + 0.15e2 / 0.32e2 * t1952 + 0.15e2 / 0.32e2 * t2002 - 0.75e2 / 0.32e2 * t2006 + 0.45e2 / 0.32e2 * t2008;
  t2011 = t348 * t913;
  t2022 = t147 * t93 * t149 * t770;
  t2024 = t348 * t917;
  t2026 = t780 * t411;
  t2028 = t1736 * t172;
  t2030 = 0.45e2 / 0.32e2 * t2011 + 0.15e2 / 0.16e2 * t1932 - 0.5e1 / 0.16e2 * t1899 - t1844 + 0.5e1 / 0.32e2 * t1891 - 0.25e2 / 0.96e2 * t1905 - 0.15e2 / 0.64e2 * t1927 + 0.25e2 / 0.32e2 * t1936 - 0.25e2 / 0.24e2 * t1956 + 0.275e3 / 0.72e2 * t2022 - 0.25e2 / 0.8e1 * t2024 + 0.75e2 / 0.64e2 * t2026 - 0.15e2 / 0.64e2 * t2028;
  t2032 = my_piecewise3(t48, 0, t2010 + t2030);
  tv4rho3lapl7 = t5 * t2032 + 0.3e1 * t921;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t2047 = 0.135e3 / 0.4e1 * t1766 - 0.15e2 / 0.4e1 * t1768 + 0.75e2 / 0.4e1 * t1772 - 0.15e2 / 0.4e1 * t1776 - 0.45e2 / 0.4e1 * t1778 - 0.15e2 / 0.2e1 * t1780 - 0.45e2 / 0.4e1 * t1782 + 0.45e2 / 0.4e1 * t1784 + 0.25e2 / 0.2e1 * t1786 - 0.45e2 * t1791 - 0.225e3 / 0.4e1 * t1796 - 0.5e2 * t1801;
  t2059 = 0.25e2 / 0.36e2 * t1828;
  t2061 = 0.135e3 / 0.4e1 * t1804 + 0.75e2 / 0.2e1 * t1806 + 0.5e1 / 0.2e1 * t1808 - 0.275e3 / 0.9e1 * t1812 + 0.25e2 / 0.12e2 * t1814 + 0.25e2 / 0.3e1 * t1816 + 0.15e2 / 0.8e1 * t1818 - 0.75e2 / 0.8e1 * t1820 - 0.5e1 / 0.4e1 * t1822 - 0.25e2 / 0.4e1 * t1824 + 0.25e2 * t1826 + t2059 + 0.15e2 / 0.8e1 * t1830;
  t2063 = my_piecewise3(t2, 0, t2047 + t2061);
  tv4rho3tau0 = t5 * t2063 + 0.3e1 * t936;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2069 = 0.25e2 / 0.36e2 * t1843;
  t2071 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t1837 + 0.15e2 / 0.8e1 * t1839 - 0.5e1 / 0.4e1 * t1841 + t2069);
  tv4rho3tau1 = t5 * t2071 + 0.3e1 * t943;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t2073 = 0.2e1 * t953;
  t2074 = 0.5e1 / 0.4e1 * t1849;
  t2078 = 0.5e1 / 0.2e1 * t1857;
  t2079 = 0.25e2 / 0.12e2 * t1859;
  t2085 = t2074 - 0.15e2 / 0.2e1 * t1851 - 0.25e2 / 0.4e1 * t1853 - 0.5e1 / 0.12e2 * t1855 - t2078 - t2079 - 0.15e2 / 0.4e1 * t1861 + 0.25e2 / 0.3e1 * t1863 + 0.5e1 / 0.3e1 * t1808 + 0.25e2 / 0.18e2 * t1814 - 0.5e1 / 0.4e1 * t1768;
  t2096 = 0.25e2 / 0.9e1 * t1816 + 0.5e1 / 0.8e1 * t1818 - 0.5e1 / 0.6e1 * t1822 - 0.5e1 / 0.2e1 * t1780 - 0.25e2 / 0.12e2 * t1824 + t2059 + 0.15e2 / 0.8e1 * t1874 + 0.45e2 / 0.4e1 * t1876 + 0.25e2 / 0.2e1 * t1878 + 0.15e2 / 0.4e1 * t1784 + 0.25e2 / 0.6e1 * t1786;
  t2098 = my_piecewise3(t2, 0, t2085 + t2096);
  tv4rho3tau2 = t5 * t2098 + t2073 + t936;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t2100 = 0.2e1 * t963;
  t2102 = 0.5e1 / 0.4e1 * t1889;
  t2107 = 0.5e1 / 0.2e1 * t1897;
  t2110 = 0.25e2 / 0.12e2 * t1903;
  t2112 = 0.15e2 / 0.8e1 * t1887 + t2102 - 0.5e1 / 0.12e2 * t1891 + 0.5e1 / 0.8e1 * t1839 - 0.5e1 / 0.6e1 * t1841 + t2069 - 0.15e2 / 0.4e1 * t1895 - t2107 + 0.5e1 / 0.6e1 * t1899 - 0.25e2 / 0.8e1 * t1901 - t2110 + 0.25e2 / 0.36e2 * t1905;
  t2113 = my_piecewise3(t48, 0, t2112);
  tv4rho3tau3 = t5 * t2113 + t2100 + t943;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t2123 = 0.15e2 / 0.8e1 * t1910 + 0.5e1 / 0.8e1 * t1912 - 0.15e2 / 0.4e1 * t1914 - 0.25e2 / 0.8e1 * t1916 + t2074 - 0.5e1 / 0.6e1 * t1855 - t2078 - t2079 - 0.5e1 / 0.12e2 * t1822 + t2059 + 0.5e1 / 0.6e1 * t1808 + 0.25e2 / 0.36e2 * t1814;
  t2124 = my_piecewise3(t2, 0, t2123);
  tv4rho3tau4 = t5 * t2124 + t2073 + t969;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t2134 = 0.15e2 / 0.8e1 * t1925 + 0.5e1 / 0.8e1 * t1927 + t2102 - 0.5e1 / 0.6e1 * t1891 - 0.15e2 / 0.2e1 * t1930 - 0.5e1 / 0.2e1 * t1932 - 0.25e2 / 0.4e1 * t1934 - 0.25e2 / 0.12e2 * t1936 - 0.5e1 / 0.12e2 * t1841 + t2069 - t2107;
  t2145 = 0.5e1 / 0.3e1 * t1899 - t2110 + 0.25e2 / 0.18e2 * t1905 + 0.45e2 / 0.4e1 * t1942 + 0.15e2 / 0.4e1 * t1944 + 0.25e2 / 0.2e1 * t1946 + 0.25e2 / 0.6e1 * t1948 - 0.15e2 / 0.4e1 * t1950 - 0.5e1 / 0.4e1 * t1952 + 0.25e2 / 0.3e1 * t1954 + 0.25e2 / 0.9e1 * t1956;
  t2147 = my_piecewise3(t48, 0, t2134 + t2145);
  tv4rho3tau5 = t5 * t2147 + t2100 + t983;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t2154 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t1963 + 0.15e2 / 0.8e1 * t1912 - 0.5e1 / 0.4e1 * t1855 + t2059);
  tv4rho3tau6 = t5 * t2154 + 0.3e1 * t969;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t2169 = 0.135e3 / 0.4e1 * t1976 - 0.45e2 * t1981 - 0.225e3 / 0.4e1 * t1986 - 0.5e2 * t1991 + 0.135e3 / 0.4e1 * t1993 + 0.75e2 / 0.2e1 * t1995 + 0.45e2 / 0.4e1 * t1944 + 0.25e2 / 0.2e1 * t1948 - 0.15e2 / 0.4e1 * t1952 - 0.15e2 / 0.4e1 * t2002 + 0.75e2 / 0.4e1 * t2006 - 0.45e2 / 0.4e1 * t2008;
  t2182 = -0.45e2 / 0.4e1 * t2011 - 0.15e2 / 0.2e1 * t1932 + 0.5e1 / 0.2e1 * t1899 + t2069 - 0.5e1 / 0.4e1 * t1891 + 0.25e2 / 0.12e2 * t1905 + 0.15e2 / 0.8e1 * t1927 - 0.25e2 / 0.4e1 * t1936 + 0.25e2 / 0.3e1 * t1956 - 0.275e3 / 0.9e1 * t2022 + 0.25e2 * t2024 - 0.75e2 / 0.8e1 * t2026 + 0.15e2 / 0.8e1 * t2028;
  t2184 = my_piecewise3(t48, 0, t2169 + t2182);
  tv4rho3tau7 = t5 * t2184 + 0.3e1 * t983;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  tv4rho2sigma26 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  tv4rho2sigma212 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t2187 = t463 * t442;
  t2189 = t469 * t442;
  t2191 = t204 * t991;
  t2193 = t204 * t997;
  t2195 = t480 * t442;
  t2196 = 0.5e1 / 0.192e3 * t2195;
  t2197 = t213 * t991;
  t2199 = t213 * t997;
  t2204 = t92 * t93 * t1171 * t440 * t218;
  t2209 = t92 * t93 * t527 * t995 * t103;
  t2213 = t92 * t93 * t989 * t230;
  t2219 = t92 * t93 * t217 / t33 / t1075;
  t2221 = -0.15e2 / 0.128e3 * t2187 - 0.5e1 / 0.64e2 * t2189 + 0.45e2 / 0.64e2 * t2191 + 0.25e2 / 0.32e2 * t2193 + t2196 + 0.15e2 / 0.64e2 * t2197 + 0.25e2 / 0.96e2 * t2199 - 0.45e2 / 0.32e2 * t2204 - 0.75e2 / 0.32e2 * t2209 + 0.45e2 / 0.128e3 * t2213 - 0.325e3 / 0.192e3 * t2219;
  t2222 = my_piecewise3(t2, 0, t2221);
  tv4rho2lapl20 = t5 * t2222 + 0.2e1 * t1001;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t2225 = t646 * t449;
  t2227 = t649 * t449;
  t2229 = t652 * t449;
  t2230 = 0.5e1 / 0.192e3 * t2229;
  t2232 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t2225 - 0.5e1 / 0.64e2 * t2227 + t2230);
  tv4rho2lapl22 = t5 * t2232 + 0.2e1 * t1008;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t2234 = t598 * t442;
  t2236 = t604 * t442;
  t2238 = t280 * t991;
  t2240 = t280 * t997;
  t2246 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2234 - 0.5e1 / 0.128e3 * t2236 + 0.45e2 / 0.128e3 * t2238 + 0.25e2 / 0.64e2 * t2240 - 0.5e1 / 0.128e3 * t2189 + t2196 + 0.15e2 / 0.128e3 * t2197 + 0.25e2 / 0.192e3 * t2199);
  tv4rho2lapl23 = t5 * t2246 + t1001 + t1013;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t2248 = t710 * t449;
  t2250 = t713 * t449;
  t2253 = t304 * t1019;
  t2255 = t307 * t1019;
  t2257 = t304 * t1025;
  t2259 = t307 * t1025;
  t2262 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t2248 - 0.5e1 / 0.128e3 * t2250 - 0.5e1 / 0.128e3 * t2227 + t2230 + 0.45e2 / 0.128e3 * t2253 + 0.15e2 / 0.128e3 * t2255 + 0.25e2 / 0.64e2 * t2257 + 0.25e2 / 0.192e3 * t2259);
  tv4rho2lapl25 = t5 * t2262 + t1008 + t1029;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t2265 = t680 * t442;
  t2269 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2265 - 0.5e1 / 0.64e2 * t2236 + t2196);
  tv4rho2lapl26 = t5 * t2269 + 0.2e1 * t1013;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t2272 = t780 * t449;
  t2275 = t348 * t1019;
  t2277 = t348 * t1025;
  t2284 = t147 * t93 * t1730 * t447 * t354;
  t2289 = t147 * t93 * t790 * t1023 * t157;
  t2293 = t147 * t93 * t1017 * t366;
  t2299 = t147 * t93 * t353 / t59 / t1082;
  t2301 = -0.15e2 / 0.128e3 * t2272 - 0.5e1 / 0.64e2 * t2250 + 0.45e2 / 0.64e2 * t2275 + 0.25e2 / 0.32e2 * t2277 + t2230 + 0.15e2 / 0.64e2 * t2255 + 0.25e2 / 0.96e2 * t2259 - 0.45e2 / 0.32e2 * t2284 - 0.75e2 / 0.32e2 * t2289 + 0.45e2 / 0.128e3 * t2293 - 0.325e3 / 0.192e3 * t2299;
  t2302 = my_piecewise3(t48, 0, t2301);
  tv4rho2lapl28 = t5 * t2302 + 0.2e1 * t1029;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  t2309 = 0.5e1 / 0.24e2 * t2195;
  t2316 = 0.15e2 / 0.16e2 * t2187 + 0.5e1 / 0.8e1 * t2189 - 0.45e2 / 0.8e1 * t2191 - 0.25e2 / 0.4e1 * t2193 - t2309 - 0.15e2 / 0.8e1 * t2197 - 0.25e2 / 0.12e2 * t2199 + 0.45e2 / 0.4e1 * t2204 + 0.75e2 / 0.4e1 * t2209 - 0.45e2 / 0.16e2 * t2213 + 0.325e3 / 0.24e2 * t2219;
  t2317 = my_piecewise3(t2, 0, t2316);
  tv4rho2lapltau0 = t5 * t2317 + 0.2e1 * t1036;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  t2322 = 0.5e1 / 0.24e2 * t2229;
  t2324 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t2225 + 0.5e1 / 0.8e1 * t2227 - t2322);
  tv4rho2lapltau3 = t5 * t2324 + 0.2e1 * t1041;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  t2334 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2234 + 0.5e1 / 0.16e2 * t2236 - 0.45e2 / 0.16e2 * t2238 - 0.25e2 / 0.8e1 * t2240 + 0.5e1 / 0.16e2 * t2189 - t2309 - 0.15e2 / 0.16e2 * t2197 - 0.25e2 / 0.24e2 * t2199);
  tv4rho2lapltau4 = t5 * t2334 + t1036 + t1045;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  t2344 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t2248 + 0.5e1 / 0.16e2 * t2250 + 0.5e1 / 0.16e2 * t2227 - t2322 - 0.45e2 / 0.16e2 * t2253 - 0.15e2 / 0.16e2 * t2255 - 0.25e2 / 0.8e1 * t2257 - 0.25e2 / 0.24e2 * t2259);
  tv4rho2lapltau7 = t5 * t2344 + t1041 + t1051;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  t2350 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2265 + 0.5e1 / 0.8e1 * t2236 - t2309);
  tv4rho2lapltau8 = t5 * t2350 + 0.2e1 * t1045;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  t2363 = 0.15e2 / 0.16e2 * t2272 + 0.5e1 / 0.8e1 * t2250 - 0.45e2 / 0.8e1 * t2275 - 0.25e2 / 0.4e1 * t2277 - t2322 - 0.15e2 / 0.8e1 * t2255 - 0.25e2 / 0.12e2 * t2259 + 0.45e2 / 0.4e1 * t2284 + 0.75e2 / 0.4e1 * t2289 - 0.45e2 / 0.16e2 * t2293 + 0.325e3 / 0.24e2 * t2299;
  t2364 = my_piecewise3(t48, 0, t2363);
  tv4rho2lapltau11 = t5 * t2364 + 0.2e1 * t1051;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t2371 = 0.5e1 / 0.3e1 * t2195;
  t2378 = -0.15e2 / 0.2e1 * t2187 - 0.5e1 * t2189 + 0.45e2 * t2191 + 0.5e2 * t2193 + t2371 + 0.15e2 * t2197 + 0.5e2 / 0.3e1 * t2199 - 0.9e2 * t2204 - 0.15e3 * t2209 + 0.45e2 / 0.2e1 * t2213 - 0.325e3 / 0.3e1 * t2219;
  t2379 = my_piecewise3(t2, 0, t2378);
  tv4rho2tau20 = t5 * t2379 + 0.2e1 * t1058;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t2384 = 0.5e1 / 0.3e1 * t2229;
  t2386 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t2225 - 0.5e1 * t2227 + t2384);
  tv4rho2tau22 = t5 * t2386 + 0.2e1 * t1063;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t2396 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2234 - 0.5e1 / 0.2e1 * t2236 + 0.45e2 / 0.2e1 * t2238 + 0.25e2 * t2240 - 0.5e1 / 0.2e1 * t2189 + t2371 + 0.15e2 / 0.2e1 * t2197 + 0.25e2 / 0.3e1 * t2199);
  tv4rho2tau23 = t5 * t2396 + t1058 + t1067;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t2406 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t2248 - 0.5e1 / 0.2e1 * t2250 - 0.5e1 / 0.2e1 * t2227 + t2384 + 0.45e2 / 0.2e1 * t2253 + 0.15e2 / 0.2e1 * t2255 + 0.25e2 * t2257 + 0.25e2 / 0.3e1 * t2259);
  tv4rho2tau25 = t5 * t2406 + t1063 + t1073;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t2412 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2265 - 0.5e1 * t2236 + t2371);
  tv4rho2tau26 = t5 * t2412 + 0.2e1 * t1067;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t2425 = -0.15e2 / 0.2e1 * t2272 - 0.5e1 * t2250 + 0.45e2 * t2275 + 0.5e2 * t2277 + t2384 + 0.15e2 * t2255 + 0.5e2 / 0.3e1 * t2259 - 0.9e2 * t2284 - 0.15e3 * t2289 + 0.45e2 / 0.2e1 * t2293 - 0.325e3 / 0.3e1 * t2299;
  t2426 = my_piecewise3(t48, 0, t2425);
  tv4rho2tau28 = t5 * t2426 + 0.2e1 * t1073;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  tv4rhosigma30 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t2428 = t204 * t1078;
  t2430 = t213 * t1078;
  t2431 = 0.15e2 / 0.512e3 * t2430;
  t2435 = t92 * t93 * t1171 * t1076 * t103;
  t2437 = t485 * t96;
  t2441 = t92 * t93 * t527 / t2437;
  t2444 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2428 - t2431 + 0.45e2 / 0.128e3 * t2435 + 0.225e3 / 0.512e3 * t2441);
  tv4rholapl30 = t5 * t2444 + t1081;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t2446 = t304 * t1085;
  t2448 = t307 * t1085;
  t2449 = 0.15e2 / 0.512e3 * t2448;
  t2451 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2446 - t2449);
  tv4rholapl33 = t5 * t2451 + t1088;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t2453 = t280 * t1078;
  t2456 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2453 - t2431);
  tv4rholapl34 = t5 * t2456 + t1081;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t2458 = t348 * t1085;
  t2463 = t147 * t93 * t1730 * t1083 * t157;
  t2465 = t768 * t150;
  t2469 = t147 * t93 * t790 / t2465;
  t2472 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2458 - t2449 + 0.45e2 / 0.128e3 * t2463 + 0.225e3 / 0.512e3 * t2469);
  tv4rholapl37 = t5 * t2472 + t1088;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  t2475 = 0.15e2 / 0.64e2 * t2430;
  t2479 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2428 + t2475 - 0.45e2 / 0.16e2 * t2435 - 0.225e3 / 0.64e2 * t2441);
  tv4rholapl2tau0 = t5 * t2479 + t1090;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  t2482 = 0.15e2 / 0.64e2 * t2448;
  t2484 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2446 + t2482);
  tv4rholapl2tau5 = t5 * t2484 + t1092;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  t2488 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2453 + t2475);
  tv4rholapl2tau6 = t5 * t2488 + t1090;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  t2494 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2458 + t2482 - 0.45e2 / 0.16e2 * t2463 - 0.225e3 / 0.64e2 * t2469);
  tv4rholapl2tau11 = t5 * t2494 + t1092;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  t2497 = 0.15e2 / 0.8e1 * t2430;
  t2501 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2428 - t2497 + 0.45e2 / 0.2e1 * t2435 + 0.225e3 / 0.8e1 * t2441);
  tv4rholapltau20 = t5 * t2501 + t1094;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  t2504 = 0.15e2 / 0.8e1 * t2448;
  t2506 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2446 - t2504);
  tv4rholapltau25 = t5 * t2506 + t1096;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  t2510 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2453 - t2497);
  tv4rholapltau26 = t5 * t2510 + t1094;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  t2516 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2458 - t2504 + 0.45e2 / 0.2e1 * t2463 + 0.225e3 / 0.8e1 * t2469);
  tv4rholapltau211 = t5 * t2516 + t1096;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t2519 = 0.15e2 * t2430;
  t2523 = my_piecewise3(t2, 0, 0.45e2 * t2428 + t2519 - 0.18e3 * t2435 - 0.225e3 * t2441);
  tv4rhotau30 = t5 * t2523 + t1098;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t2526 = 0.15e2 * t2448;
  t2528 = my_piecewise3(t48, 0, 0.45e2 * t2446 + t2526);
  tv4rhotau33 = t5 * t2528 + t1100;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t2532 = my_piecewise3(t2, 0, 0.45e2 * t2453 + t2519);
  tv4rhotau34 = t5 * t2532 + t1098;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t2538 = my_piecewise3(t48, 0, 0.45e2 * t2458 + t2526 - 0.18e3 * t2463 - 0.225e3 * t2469);
  tv4rhotau37 = t5 * t2538 + t1100;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  tv4sigma40 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t2544 = t92 * t93 * t1171 / t34 / t2437;
  t2546 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2544);
  tv4lapl40 = t5 * t2546;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t2551 = t147 * t93 * t1730 / t60 / t2465;
  t2553 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2551);
  tv4lapl44 = t5 * t2553;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  t2555 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2544);
  tv4lapl3tau0 = t5 * t2555;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  t2557 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2551);
  tv4lapl3tau7 = t5 * t2557;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  t2559 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2544);
  tv4lapl2tau20 = t5 * t2559;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  t2561 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2551);
  tv4lapl2tau28 = t5 * t2561;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  t2563 = my_piecewise3(t2, 0, 0.45e2 * t2544);
  tv4lapltau30 = t5 * t2563;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  t2565 = my_piecewise3(t48, 0, 0.45e2 * t2551);
  tv4lapltau37 = t5 * t2565;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t2567 = my_piecewise3(t2, 0, -0.36e3 * t2544);
  tv4tau40 = t5 * t2567;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t2569 = my_piecewise3(t48, 0, -0.36e3 * t2551);
  tv4tau44 = t5 * t2569;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

